/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

public class EscapeLiteralSQL {
    private String substitute = "@";
    private String substitute_num = "@";
    private boolean substitute_str_mode = true;
    private char[] chars;
    private int pos;
    private int length;
    private int count;
    private int comment_su;
    final StringBuffer parsedSql;
    final StringBuffer param;
    private STAT status;

    public EscapeLiteralSQL(String sql) {
        this.chars = sql.toCharArray();
        this.length = this.chars.length;
        this.parsedSql = new StringBuffer(this.length + 10);
        this.param = new StringBuffer();
    }

    public EscapeLiteralSQL setSubstitute(String chr) {
        this.substitute = chr;
        this.substitute_num = this.substitute_str_mode ? "'" + chr + "'" : this.substitute;
        return this;
    }

    public EscapeLiteralSQL setSubstituteStringMode(boolean b) {
        if (this.substitute_str_mode == b) {
            return this;
        }
        this.substitute_str_mode = b;
        this.substitute_num = this.substitute_str_mode ? "'" + this.substitute + "'" : this.substitute;
        return this;
    }

    public EscapeLiteralSQL process() {
        this.status = STAT.NORMAL;
        this.pos = 0;
        while (this.pos < this.chars.length) {
            switch (this.chars[this.pos]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this._number();
                    break;
                }
                case ':': {
                    this._colon();
                    break;
                }
                case '.': {
                    this._dot();
                    break;
                }
                case '-': {
                    this._minus();
                    break;
                }
                case '/': {
                    this._slash();
                    break;
                }
                case '*': {
                    this._astar();
                    break;
                }
                case '\'': {
                    this._qutation();
                    break;
                }
                default: {
                    this._others();
                }
            }
            ++this.pos;
        }
        return this;
    }

    private void _others() {
        switch (this.status) {
            case COMMENT: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case ALPABET: {
                this.parsedSql.append(this.chars[this.pos]);
                if (this.isProgLetter(this.chars[this.pos])) break;
                this.status = STAT.NORMAL;
                break;
            }
            case NUMBER: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = STAT.NORMAL;
                break;
            }
            case QUTATION: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                this.status = this.isProgLetter(this.chars[this.pos]) ? STAT.ALPABET : STAT.NORMAL;
                this.parsedSql.append(this.chars[this.pos]);
            }
        }
    }

    private boolean isProgLetter(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private void _colon() {
        switch (this.status) {
            case COMMENT: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case QUTATION: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = STAT.COLON;
            }
        }
    }

    private void _qutation() {
        switch (this.status) {
            case NORMAL: {
                if (this.param.length() > 0) {
                    this.param.append(",");
                }
                this.param.append(this.chars[this.pos]);
                this.status = STAT.QUTATION;
                break;
            }
            case COMMENT: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case ALPABET: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = STAT.QUTATION;
                break;
            }
            case NUMBER: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = STAT.QUTATION;
                break;
            }
            case QUTATION: {
                this.param.append("'");
                this.parsedSql.append('\'').append(this.substitute).append("{").append(++this.count).append("}").append('\'');
                this.status = STAT.NORMAL;
            }
        }
    }

    private void _astar() {
        switch (this.status) {
            case COMMENT: {
                this.parsedSql.append(this.chars[this.pos]);
                if (this.getNext(this.pos) != '/') break;
                this.parsedSql.append('/');
                ++this.pos;
                if (--this.comment_su != 0) break;
                this.status = STAT.NORMAL;
                break;
            }
            case QUTATION: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = STAT.NORMAL;
            }
        }
    }

    private void _slash() {
        switch (this.status) {
            case COMMENT: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case QUTATION: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            default: {
                if (this.getNext(this.pos) != '*') break;
                ++this.pos;
                ++this.comment_su;
                this.parsedSql.append("/*");
                this.status = STAT.COMMENT;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _minus() {
        switch (this.status) {
            case COMMENT: {
                this.parsedSql.append(this.chars[this.pos]);
                return;
            }
            case QUTATION: {
                this.param.append(this.chars[this.pos]);
                return;
            }
        }
        if (this.getNext(this.pos) == '-') {
            this.parsedSql.append(this.chars[this.pos]);
            while (this.chars[this.pos] != '\n') {
                ++this.pos;
                if (this.pos < this.length) {
                    this.parsedSql.append(this.chars[this.pos]);
                    continue;
                }
                break;
            }
        } else {
            this.parsedSql.append(this.chars[this.pos]);
        }
        this.status = STAT.NORMAL;
    }

    private void _dot() {
        switch (this.status) {
            case NORMAL: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case COMMENT: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case ALPABET: {
                this.parsedSql.append(this.chars[this.pos]);
                this.status = STAT.NORMAL;
                break;
            }
            case NUMBER: {
                this.param.append(this.chars[this.pos]);
                break;
            }
            case QUTATION: {
                this.param.append(this.chars[this.pos]);
            }
        }
    }

    private void _number() {
        switch (this.status) {
            case NORMAL: {
                if (this.param.length() > 0) {
                    this.param.append(",");
                }
                this.param.append(this.chars[this.pos]);
                this.parsedSql.append(this.substitute_num).append("{").append(++this.count).append("}");
                this.status = STAT.NUMBER;
                break;
            }
            case COMMENT: 
            case ALPABET: 
            case COLON: {
                this.parsedSql.append(this.chars[this.pos]);
                break;
            }
            case NUMBER: 
            case QUTATION: {
                this.param.append(this.chars[this.pos]);
            }
        }
    }

    private char getNext(int x) {
        return x < this.length ? this.chars[x + 1] : (char)'\u0000';
    }

    public static void main(String[] args) throws Exception {
        String s = "select  aa_1 ,( a - b)  as b from tab";
        long time = System.currentTimeMillis();
        EscapeLiteralSQL ec = new EscapeLiteralSQL(s).process();
        long etime = System.currentTimeMillis();
        System.out.println("SQL Orgin: " + s);
        System.out.println("SQL Parsed: " + ec.getParsedSql());
        System.out.println("PARAM: " + ec.param);
    }

    public String getParsedSql() {
        return this.parsedSql.toString();
    }

    public String getParameter() {
        return this.param.toString();
    }

    static enum STAT {
        NORMAL,
        COMMENT,
        ALPABET,
        NUMBER,
        QUTATION,
        COLON;

    }
}

