/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport;

import java.util.ArrayList;
import java.util.List;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.asm.IASM;
import scouter.agent.asm.asyncsupport.CallRunnableCV;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.util.StringUtil;

public class CallRunnableASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();
    private static final String CALLABLE = "java/util/concurrent/Callable";
    private static final String RUNNABLE = "java/lang/Runnable";
    private static List<String> scanScopePrefix = new ArrayList<String>();

    public CallRunnableASM() {
        if (this.conf.hook_spring_async_enabled) {
            scanScopePrefix.add("org/springframework/aop/interceptor/AsyncExecutionInterceptor");
        }
        if (this.conf.hook_async_callrunnable_enabled) {
            String[] prefixes = StringUtil.split(this.conf.hook_async_callrunnable_scan_package_prefixes, ',');
            for (int i = 0; i < prefixes.length; ++i) {
                Logger.println("Callable Runnable scan scope : " + prefixes[i]);
                scanScopePrefix.add(prefixes[i].replace('.', '/'));
            }
        }
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        String[] interfaces = classDesc.interfaces;
        for (int inx = 0; inx < interfaces.length; ++inx) {
            if (!CALLABLE.equals(interfaces[inx]) && !RUNNABLE.equals(interfaces[inx])) continue;
            for (int jnx = 0; jnx < scanScopePrefix.size(); ++jnx) {
                if (className.indexOf(scanScopePrefix.get(jnx)) != 0) continue;
                return new CallRunnableCV(cv, className);
            }
        }
        return cv;
    }
}

