/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.redis;

import scouter.agent.Logger;
import scouter.agent.asm.redis.GetKeyBytesMV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.FieldVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;

class RedisCacheKeyCV
extends ClassVisitor
implements Opcodes {
    String className;
    HookingSet mset;
    boolean existKeyElementField;

    public RedisCacheKeyCV(ClassVisitor cv, HookingSet mset, String className) {
        super(327680, cv);
        this.mset = mset;
        this.className = className;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("keyElement") && desc.equals("Ljava/lang/Object;")) {
            this.existKeyElementField = true;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!this.existKeyElementField) {
            Logger.println("A902", "Ignore hooking - No Field keyElement on " + this.className);
            return mv;
        }
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isSpecial(name)) {
            return mv;
        }
        return new GetKeyBytesMV(access, this.className, name, desc, mv);
    }
}

