/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallStep2;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.DispatchStep;
import scouter.lang.step.DumpStep;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.MessageStep;
import scouter.lang.step.MessageSum;
import scouter.lang.step.MethodStep;
import scouter.lang.step.MethodStep2;
import scouter.lang.step.MethodSum;
import scouter.lang.step.ParameterizedMessageStep;
import scouter.lang.step.SocketStep;
import scouter.lang.step.SocketSum;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlStep2;
import scouter.lang.step.SqlStep3;
import scouter.lang.step.SqlSum;
import scouter.lang.step.Step;
import scouter.lang.step.StepControl;
import scouter.lang.step.ThreadCallPossibleStep;
import scouter.lang.step.ThreadSubmitStep;

public class StepEnum {
    public static final byte METHOD = 1;
    public static final byte METHOD2 = 10;
    public static final byte SQL = 2;
    public static final byte SQL2 = 8;
    public static final byte SQL3 = 16;
    public static final byte MESSAGE = 3;
    public static final byte SOCKET = 5;
    public static final byte APICALL = 6;
    public static final byte APICALL2 = 15;
    public static final byte THREAD_SUBMIT = 7;
    public static final byte HASHED_MESSAGE = 9;
    public static final byte PARAMETERIZED_MESSAGE = 17;
    public static final byte DUMP = 12;
    public static final byte DISPATCH = 13;
    public static final byte THREAD_CALL_POSSIBLE = 14;
    public static final byte METHOD_SUM = 11;
    public static final byte SQL_SUM = 21;
    public static final byte MESSAGE_SUM = 31;
    public static final byte SOCKET_SUM = 42;
    public static final byte APICALL_SUM = 43;
    public static final byte CONTROL = 99;

    public static Step create(byte type) {
        try {
            return Type.of(type).create();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static enum Type {
        METHOD(1, MethodStep.class, "method"),
        METHOD2(10, MethodStep2.class, "method"),
        SQL(2, SqlStep.class, "sql"),
        SQL2(8, SqlStep2.class, "sql"),
        SQL3(16, SqlStep3.class, "sql"),
        MESSAGE(3, MessageStep.class, null),
        SOCKET(5, SocketStep.class, null),
        APICALL(6, ApiCallStep.class, "apicall"),
        APICALL2(15, ApiCallStep2.class, "apicall"),
        THREAD_SUBMIT(7, ThreadSubmitStep.class, "apicall"),
        HASHED_MESSAGE(9, HashedMessageStep.class, "hmsg"),
        PARAMETERIZED_MESSAGE(17, ParameterizedMessageStep.class, "hmsg"),
        DUMP(12, DumpStep.class, null),
        DISPATCH(13, DispatchStep.class, "apicall"),
        THREAD_CALL_POSSIBLE(14, ThreadCallPossibleStep.class, "apicall"),
        METHOD_SUM(11, MethodSum.class, "method"),
        SQL_SUM(21, SqlSum.class, "sql"),
        MESSAGE_SUM(31, MessageSum.class, null),
        SOCKET_SUM(42, SocketSum.class, null),
        APICALL_SUM(43, ApiCallSum.class, "apicall"),
        CONTROL(99, StepControl.class, null);

        byte code;
        Class<? extends Step> clazz;
        String associatedMainTextTypeName;

        private Type(byte code, Class<? extends Step> clazz, String textType) {
            this.code = code;
            this.clazz = clazz;
            this.associatedMainTextTypeName = textType;
        }

        public static Type of(String name) {
            for (Type t : Type.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            throw new RuntimeException("unknown profile type=" + name);
        }

        public static Type of(byte code) {
            for (Type t : Type.values()) {
                if (t.code != code) continue;
                return t;
            }
            throw new RuntimeException("unknown profile type=" + code);
        }

        public Step create() throws IllegalAccessException, InstantiationException {
            return this.clazz.newInstance();
        }

        public byte getCode() {
            return this.code;
        }

        public Class<? extends Step> getClazz() {
            return this.clazz;
        }

        public String getAssociatedMainTextTypeName() {
            return this.associatedMainTextTypeName;
        }
    }
}

