/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import scouter.agent.AgentBoot;
import scouter.agent.AgentTransformer;
import scouter.agent.BackJobs;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.netio.data.net.TcpRequestMgr;
import scouter.agent.util.AsyncRunner;
import scouter.util.StringSet;
import scouter.util.logo.Logo;

public class JavaAgent {
    private static Instrumentation instrumentation;
    private static boolean java9plus;
    private static ClassLoader platformClassLoader;

    public static void premain(String options, Instrumentation instrum) {
        Configure conf = Configure.getInstance();
        if (conf._hook_coroutine_debugger_hook_enabled && System.getProperty("kotlinx.coroutines.debug") == null) {
            System.setProperty("kotlinx.coroutines.debug", "");
        }
        JavaAgent.preStart(options, instrum, new AgentTransformer());
    }

    public static void preStart(String options, Instrumentation instrum, ClassFileTransformer transformer) {
        if (instrumentation != null) {
            return;
        }
        JavaAgent.intro();
        Configure conf = Configure.getInstance();
        BackJobs.getInstance().put(Logger.class.getName(), 3000, Logger.initializer);
        instrumentation = instrum;
        instrumentation.addTransformer(transformer);
        JavaAgent.addAsyncRedefineClasses();
        TcpRequestMgr.getInstance();
        AsyncRunner.getInstance().add(new AgentBoot());
    }

    private static void addAsyncRedefineClasses() {
        StringSet redefineClasses = new StringSet();
        if (Logger.conf._hook_map_impl_enabled) {
            redefineClasses.put("java.util.HashMap");
            redefineClasses.put("java.util.LinkedHashMap");
            redefineClasses.put("java.util.concurrent.ConcurrentHashMap");
            redefineClasses.put("java.util.HashTable");
        }
        redefineClasses.put("java.util.concurrent.AbstractExecutorService");
        redefineClasses.put("java.util.concurrent.ThreadPoolExecutor");
        redefineClasses.put("java.lang.Thread");
        AsyncRunner.getInstance().add(redefineClasses);
    }

    private static void intro() {
        try {
            System.setProperty("scouter.enabled", "true");
            Logo.print(false);
            String nativeName = JavaAgent.class.getName().replace('.', '/') + ".class";
            ClassLoader cl = JavaAgent.class.getClassLoader();
            if (cl == null) {
                Logger.println("loaded by system classloader ");
                Logger.println(JavaAgent.cut("" + ClassLoader.getSystemClassLoader().getResource(nativeName)));
            } else {
                Logger.println("loaded by app classloader ");
                Logger.println(JavaAgent.cut("" + cl.getResource(nativeName)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String cut(String s) {
        int x = s.indexOf(33);
        return x > 0 ? s.substring(0, x) : s;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static boolean isJava9plus() {
        return java9plus;
    }

    public static ClassLoader getPlatformClassLoader() {
        return platformClassLoader;
    }

    static {
        try {
            Method m = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
            platformClassLoader = (ClassLoader)m.invoke(null, new Object[0]);
            java9plus = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

