/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.trace.AlertProxy;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.MapValue;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.Hexa32;
import scouter.util.ThreadUtil;

public class DelayedServiceManager
extends Thread {
    static final String PREFIX_SERVICE = "service.";
    static final String PREFIX_TIME = "time.";
    private static volatile DelayedServiceManager instance;
    Configure conf = Configure.getInstance();
    long lastModifiedTime;
    static volatile boolean stopChecking;
    HashMap<Integer, DelayedCondition> conditionMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DelayedServiceManager getInstance() {
        if (instance != null) return instance;
        Class<DelayedServiceManager> clazz = DelayedServiceManager.class;
        synchronized (DelayedServiceManager.class) {
            if (instance != null) return instance;
            instance = new DelayedServiceManager();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void run() {
        while (this.conf.isAlive()) {
            this.load();
            ThreadUtil.sleep(10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        String filename;
        File dir = this.conf.getPropertyFile().getParentFile();
        File file = new File(dir, filename = this.conf.trace_delayed_service_mgr_filename);
        if (file.lastModified() == this.lastModifiedTime) {
            return;
        }
        try {
            stopChecking = true;
            Logger.println("SA-2001", "Load delayed service configure file : " + file.getAbsolutePath());
            this.lastModifiedTime = file.lastModified();
            Properties properties = new Properties();
            if (file.canRead()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    properties.load(fis);
                }
                catch (Exception e) {
                    try {
                        Logger.println("SA-2002", "Load error delayed service property file", e);
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(fis);
                        throw throwable;
                    }
                    FileUtil.close(fis);
                }
                FileUtil.close(fis);
            }
            HashMap<Integer, DelayedCondition> indexMap = new HashMap<Integer, DelayedCondition>();
            for (Object key : properties.keySet()) {
                try {
                    DelayedCondition condition;
                    int index;
                    String name = key.toString();
                    if (name.startsWith(PREFIX_SERVICE)) {
                        index = Integer.valueOf(name.substring(PREFIX_SERVICE.length()));
                        condition = (DelayedCondition)indexMap.get(index);
                        if (condition == null) {
                            condition = new DelayedCondition();
                            indexMap.put(index, condition);
                        }
                        condition.service = HashUtil.hash(properties.getProperty(name).trim());
                        continue;
                    }
                    if (!name.startsWith(PREFIX_TIME)) continue;
                    index = Integer.valueOf(name.substring(PREFIX_TIME.length()));
                    condition = (DelayedCondition)indexMap.get(index);
                    if (condition == null) {
                        condition = new DelayedCondition();
                        indexMap.put(index, condition);
                    }
                    condition.time = Integer.valueOf(properties.getProperty(name));
                }
                catch (Exception exception) {}
            }
            this.conditionMap.clear();
            for (DelayedCondition condition : indexMap.values()) {
                if (condition.service == 0) continue;
                this.conditionMap.put(condition.service, condition);
            }
        }
        finally {
            stopChecking = false;
        }
    }

    public void checkDelayedService(XLogPack pack, String serviceName) {
        if (stopChecking) {
            Logger.println("SA-2003", "Pass delayed checking... " + Hexa32.toString32(pack.txid));
            return;
        }
        DelayedCondition condition = this.conditionMap.get(pack.service);
        if (condition != null && pack.elapsed > condition.time) {
            StringBuilder msg = new StringBuilder();
            msg.append(serviceName + System.getProperty("line.separator"));
            msg.append(pack.elapsed + " ms (SET:" + condition.time + " ms)" + System.getProperty("line.separator"));
            msg.append("ID = " + Hexa32.toString32(pack.txid));
            MapValue tags = null;
            if (pack.error != 0) {
                tags = new MapValue();
                tags.put(AlertPack.HASH_FLAG + "error" + "_error", pack.error);
            }
            StringBuilder titleSb = new StringBuilder();
            titleSb.append("DELAYED_SERVICE");
            if (serviceName != null && serviceName.length() > 15) {
                titleSb.append("(...");
                titleSb.append(serviceName.substring(serviceName.length() - 10));
                titleSb.append(")");
            } else {
                titleSb.append("(");
                titleSb.append(serviceName);
                titleSb.append(")");
            }
            AlertProxy.sendAlert((byte)1, titleSb.toString(), msg.toString(), tags);
        }
    }

    static {
        stopChecking = false;
    }

    private static class DelayedCondition {
        public int service;
        public int time;

        private DelayedCondition() {
        }
    }
}

