/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import scouter.agent.Configure;
import scouter.lang.conf.ConfObserver;
import scouter.lang.pack.XLogDiscardTypes;
import scouter.util.KeyGen;
import scouter.util.StringUtil;
import scouter.util.matcher.CommaSeparatedChainedStrMatcher;

public class XLogSampler {
    private static XLogSampler instance = new XLogSampler();
    private Configure conf = Configure.getInstance();
    private String currentExcludeSamplingPattern;
    private String currentConsequentSamplingIgnorePattern;
    private String currentDiscardServicePatterns;
    private String currentSamplingServicePatterns;
    private String currentSampling2ServicePatterns;
    private String currentSampling3ServicePatterns;
    private String currentSampling4ServicePatterns;
    private String currentSampling5ServicePatterns;
    private String currentFullyDiscardServicePatterns;
    private CommaSeparatedChainedStrMatcher excludeSamplingPatternMatcher;
    private CommaSeparatedChainedStrMatcher consequentSamplingIgnorePatternMatcher;
    private CommaSeparatedChainedStrMatcher discardPatternMatcher;
    private CommaSeparatedChainedStrMatcher samplingPatternMatcher;
    private CommaSeparatedChainedStrMatcher sampling2PatternMatcher;
    private CommaSeparatedChainedStrMatcher sampling3PatternMatcher;
    private CommaSeparatedChainedStrMatcher sampling4PatternMatcher;
    private CommaSeparatedChainedStrMatcher sampling5PatternMatcher;
    private CommaSeparatedChainedStrMatcher fullyDiscardPatternMatcher;

    private XLogSampler() {
        this.currentExcludeSamplingPattern = this.conf.xlog_sampling_exclude_patterns;
        this.currentConsequentSamplingIgnorePattern = this.conf.xlog_consequent_sampling_ignore_patterns;
        this.currentDiscardServicePatterns = this.conf.xlog_discard_service_patterns;
        this.currentFullyDiscardServicePatterns = this.conf.xlog_fully_discard_service_patterns;
        this.currentSamplingServicePatterns = this.conf.xlog_patterned_sampling_service_patterns;
        this.currentSampling2ServicePatterns = this.conf.xlog_patterned2_sampling_service_patterns;
        this.currentSampling3ServicePatterns = this.conf.xlog_patterned3_sampling_service_patterns;
        this.currentSampling4ServicePatterns = this.conf.xlog_patterned4_sampling_service_patterns;
        this.currentSampling5ServicePatterns = this.conf.xlog_patterned5_sampling_service_patterns;
        this.excludeSamplingPatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentExcludeSamplingPattern);
        this.consequentSamplingIgnorePatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentConsequentSamplingIgnorePattern);
        this.discardPatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentDiscardServicePatterns);
        this.fullyDiscardPatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentFullyDiscardServicePatterns);
        this.samplingPatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentSamplingServicePatterns);
        this.sampling2PatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentSampling2ServicePatterns);
        this.sampling3PatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentSampling3ServicePatterns);
        this.sampling4PatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentSampling4ServicePatterns);
        this.sampling5PatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentSampling5ServicePatterns);
        ConfObserver.add("XLogSampler.StrMatch", new Runnable(){

            @Override
            public void run() {
                XLogSampler sampler = XLogSampler.getInstance();
                Configure conf = Configure.getInstance();
                if (!sampler.currentExcludeSamplingPattern.equals(conf.xlog_sampling_exclude_patterns)) {
                    sampler.currentExcludeSamplingPattern = conf.xlog_sampling_exclude_patterns;
                    sampler.excludeSamplingPatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_sampling_exclude_patterns);
                }
                if (!sampler.currentConsequentSamplingIgnorePattern.equals(conf.xlog_consequent_sampling_ignore_patterns)) {
                    sampler.currentConsequentSamplingIgnorePattern = conf.xlog_consequent_sampling_ignore_patterns;
                    sampler.consequentSamplingIgnorePatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_consequent_sampling_ignore_patterns);
                }
                if (!sampler.currentDiscardServicePatterns.equals(conf.xlog_discard_service_patterns)) {
                    sampler.currentDiscardServicePatterns = conf.xlog_discard_service_patterns;
                    sampler.discardPatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_discard_service_patterns);
                }
                if (!sampler.currentFullyDiscardServicePatterns.equals(conf.xlog_fully_discard_service_patterns)) {
                    sampler.currentFullyDiscardServicePatterns = conf.xlog_fully_discard_service_patterns;
                    sampler.fullyDiscardPatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_fully_discard_service_patterns);
                }
                if (!sampler.currentSamplingServicePatterns.equals(conf.xlog_patterned_sampling_service_patterns)) {
                    sampler.currentSamplingServicePatterns = conf.xlog_patterned_sampling_service_patterns;
                    sampler.samplingPatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_patterned_sampling_service_patterns);
                }
                if (!sampler.currentSampling2ServicePatterns.equals(conf.xlog_patterned2_sampling_service_patterns)) {
                    sampler.currentSampling2ServicePatterns = conf.xlog_patterned2_sampling_service_patterns;
                    sampler.sampling2PatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_patterned2_sampling_service_patterns);
                }
                if (!sampler.currentSampling3ServicePatterns.equals(conf.xlog_patterned3_sampling_service_patterns)) {
                    sampler.currentSampling3ServicePatterns = conf.xlog_patterned3_sampling_service_patterns;
                    sampler.sampling3PatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_patterned3_sampling_service_patterns);
                }
                if (!sampler.currentSampling4ServicePatterns.equals(conf.xlog_patterned4_sampling_service_patterns)) {
                    sampler.currentSampling4ServicePatterns = conf.xlog_patterned4_sampling_service_patterns;
                    sampler.sampling4PatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_patterned4_sampling_service_patterns);
                }
                if (!sampler.currentSampling5ServicePatterns.equals(conf.xlog_patterned5_sampling_service_patterns)) {
                    sampler.currentSampling5ServicePatterns = conf.xlog_patterned5_sampling_service_patterns;
                    sampler.sampling5PatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_patterned5_sampling_service_patterns);
                }
            }
        });
    }

    public static XLogSampler getInstance() {
        return instance;
    }

    public XLogDiscardTypes.XLogDiscard evaluateXLogDiscard(int elapsed, String serviceName) {
        XLogDiscardTypes.XLogDiscard discardMode = XLogDiscardTypes.XLogDiscard.NONE;
        if (elapsed < this.conf.xlog_lower_bound_time_ms) {
            return XLogDiscardTypes.XLogDiscard.DISCARD_ALL_FORCE;
        }
        if (this.conf.xlog_sampling_enabled && this.isExcludeSamplingServicePattern(serviceName)) {
            return XLogDiscardTypes.XLogDiscard.NONE;
        }
        boolean isSamplingServicePattern = false;
        if (this.conf.xlog_patterned_sampling_enabled && (isSamplingServicePattern = this.isSamplingServicePattern(serviceName))) {
            discardMode = this.toForce(this.samplingPatterned1(elapsed, discardMode), serviceName);
        }
        if (!isSamplingServicePattern && this.conf.xlog_patterned2_sampling_enabled && (isSamplingServicePattern = this.isSampling2ServicePattern(serviceName))) {
            discardMode = this.toForce(this.samplingPatterned2(elapsed, discardMode), serviceName);
        }
        if (!isSamplingServicePattern && this.conf.xlog_patterned3_sampling_enabled && (isSamplingServicePattern = this.isSampling3ServicePattern(serviceName))) {
            discardMode = this.toForce(this.samplingPatterned3(elapsed, discardMode), serviceName);
        }
        if (!isSamplingServicePattern && this.conf.xlog_patterned4_sampling_enabled && (isSamplingServicePattern = this.isSampling4ServicePattern(serviceName))) {
            discardMode = this.toForce(this.samplingPatterned4(elapsed, discardMode), serviceName);
        }
        if (!isSamplingServicePattern && this.conf.xlog_patterned5_sampling_enabled && (isSamplingServicePattern = this.isSampling5ServicePattern(serviceName))) {
            discardMode = this.toForce(this.samplingPatterned5(elapsed, discardMode), serviceName);
        }
        if (!isSamplingServicePattern && this.conf.xlog_sampling_enabled) {
            discardMode = this.toForce(this.sampling4Elapsed(elapsed, discardMode), serviceName);
        }
        return discardMode;
    }

    private XLogDiscardTypes.XLogDiscard toForce(XLogDiscardTypes.XLogDiscard discardMode, String serviceName) {
        if (this.isConsequentSamplingIgnoreServicePattern(serviceName)) {
            return discardMode.toForce();
        }
        return discardMode;
    }

    private XLogDiscardTypes.XLogDiscard sampling4Elapsed(int elapsed, XLogDiscardTypes.XLogDiscard discardMode) {
        if (elapsed < this.conf.xlog_sampling_step1_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_step1_rate_pct) {
                discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_sampling_step2_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_step2_rate_pct) {
                discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_sampling_step3_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_step3_rate_pct) {
                discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_over_rate_pct) {
            discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
        }
        return discardMode;
    }

    private XLogDiscardTypes.XLogDiscard samplingPatterned5(int elapsed, XLogDiscardTypes.XLogDiscard discardMode) {
        if (elapsed < this.conf.xlog_patterned5_sampling_step1_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned5_sampling_step1_rate_pct) {
                discardMode = this.conf.xlog_patterned5_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned5_sampling_step2_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned5_sampling_step2_rate_pct) {
                discardMode = this.conf.xlog_patterned5_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned5_sampling_step3_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned5_sampling_step3_rate_pct) {
                discardMode = this.conf.xlog_patterned5_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned5_sampling_over_rate_pct) {
            discardMode = this.conf.xlog_patterned5_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
        }
        return discardMode;
    }

    private XLogDiscardTypes.XLogDiscard samplingPatterned4(int elapsed, XLogDiscardTypes.XLogDiscard discardMode) {
        if (elapsed < this.conf.xlog_patterned4_sampling_step1_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned4_sampling_step1_rate_pct) {
                discardMode = this.conf.xlog_patterned4_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned4_sampling_step2_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned4_sampling_step2_rate_pct) {
                discardMode = this.conf.xlog_patterned4_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned4_sampling_step3_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned4_sampling_step3_rate_pct) {
                discardMode = this.conf.xlog_patterned4_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned4_sampling_over_rate_pct) {
            discardMode = this.conf.xlog_patterned4_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
        }
        return discardMode;
    }

    private XLogDiscardTypes.XLogDiscard samplingPatterned3(int elapsed, XLogDiscardTypes.XLogDiscard discardMode) {
        if (elapsed < this.conf.xlog_patterned3_sampling_step1_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned3_sampling_step1_rate_pct) {
                discardMode = this.conf.xlog_patterned3_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned3_sampling_step2_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned3_sampling_step2_rate_pct) {
                discardMode = this.conf.xlog_patterned3_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned3_sampling_step3_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned3_sampling_step3_rate_pct) {
                discardMode = this.conf.xlog_patterned3_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned3_sampling_over_rate_pct) {
            discardMode = this.conf.xlog_patterned3_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
        }
        return discardMode;
    }

    private XLogDiscardTypes.XLogDiscard samplingPatterned2(int elapsed, XLogDiscardTypes.XLogDiscard discardMode) {
        if (elapsed < this.conf.xlog_patterned2_sampling_step1_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned2_sampling_step1_rate_pct) {
                discardMode = this.conf.xlog_patterned2_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned2_sampling_step2_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned2_sampling_step2_rate_pct) {
                discardMode = this.conf.xlog_patterned2_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned2_sampling_step3_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned2_sampling_step3_rate_pct) {
                discardMode = this.conf.xlog_patterned2_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned2_sampling_over_rate_pct) {
            discardMode = this.conf.xlog_patterned2_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
        }
        return discardMode;
    }

    private XLogDiscardTypes.XLogDiscard samplingPatterned1(int elapsed, XLogDiscardTypes.XLogDiscard discardMode) {
        if (elapsed < this.conf.xlog_patterned_sampling_step1_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_step1_rate_pct) {
                discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned_sampling_step2_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_step2_rate_pct) {
                discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (elapsed < this.conf.xlog_patterned_sampling_step3_ms) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_step3_rate_pct) {
                discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
            }
        } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_over_rate_pct) {
            discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscardTypes.XLogDiscard.DISCARD_PROFILE : XLogDiscardTypes.XLogDiscard.DISCARD_ALL;
        }
        return discardMode;
    }

    private boolean isExcludeSamplingServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_sampling_exclude_patterns)) {
            return false;
        }
        return this.excludeSamplingPatternMatcher.isMatch(serviceName);
    }

    private boolean isConsequentSamplingIgnoreServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_consequent_sampling_ignore_patterns)) {
            return false;
        }
        return this.consequentSamplingIgnorePatternMatcher.isMatch(serviceName);
    }

    public boolean isDiscardServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_discard_service_patterns)) {
            return false;
        }
        return this.discardPatternMatcher.isMatch(serviceName);
    }

    public boolean isFullyDiscardServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_fully_discard_service_patterns)) {
            return false;
        }
        return this.fullyDiscardPatternMatcher.isMatch(serviceName);
    }

    private boolean isSamplingServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_patterned_sampling_service_patterns)) {
            return false;
        }
        return this.samplingPatternMatcher.isMatch(serviceName);
    }

    private boolean isSampling2ServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_patterned2_sampling_service_patterns)) {
            return false;
        }
        return this.sampling2PatternMatcher.isMatch(serviceName);
    }

    private boolean isSampling3ServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_patterned3_sampling_service_patterns)) {
            return false;
        }
        return this.sampling3PatternMatcher.isMatch(serviceName);
    }

    private boolean isSampling4ServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_patterned4_sampling_service_patterns)) {
            return false;
        }
        return this.sampling4PatternMatcher.isMatch(serviceName);
    }

    private boolean isSampling5ServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_patterned5_sampling_service_patterns)) {
            return false;
        }
        return this.sampling5PatternMatcher.isMatch(serviceName);
    }
}

