/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.value;

import java.io.IOException;
import java.text.DecimalFormat;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.value.NumberValue;
import scouter.lang.value.Value;

public class DoubleValue
extends NumberValue
implements Value,
Comparable {
    public double value;

    public DoubleValue() {
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    public int compareTo(Object o) {
        if (o instanceof DoubleValue) {
            return Double.compare(this.value, ((DoubleValue)o).value);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleValue) {
            return this.value == ((DoubleValue)o).value;
        }
        return false;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    @Override
    public byte getValueType() {
        return 40;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public Value read(DataInputX in) throws IOException {
        this.value = in.readDouble();
        return this;
    }

    public String toString() {
        return new DecimalFormat("#0.0#################").format(new Double(this.value));
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public Object toJavaObject() {
        return this.value;
    }
}

