/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.HashMap;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.WebClientResponseLogCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class ApicallWebClientResponseASM
implements IASM,
Opcodes {
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public ApicallWebClientResponseASM() {
        AsmUtil.add(this.reserved, "org/springframework/web/reactive/function/client/ExchangeFunctions$DefaultExchangeFunction", "logResponse(Lorg/springframework/http/client/reactive/ClientHttpResponse;Ljava/lang/String;)V");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        Configure conf = Configure.getInstance();
        if (!conf._hook_apicall_enabled) {
            return cv;
        }
        if (!conf._hook_reactive_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new WebClientResponseLogCV(cv, mset, className);
        }
        return cv;
    }
}

