/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport;

import scouter.agent.trace.TraceMain;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

class CallOrRunMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TARGET = TraceMain.class.getName().replace('.', '/');
    private static final String START_METHOD = "callRunnableCallInvoked";
    private static final String START_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String END_METHOD = "callRunnableCallEnd";
    private static final String END_METHOD_DESC = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private Type returnType;
    String name;
    String desc;
    private int statIdx;

    public CallOrRunMV(int access, String name, String desc, MethodVisitor mv) {
        super(524288, access, desc, mv);
        this.name = name;
        this.desc = desc;
        this.returnType = Type.getReturnType(desc);
    }

    @Override
    public void visitCode() {
        this.mv.visitVarInsn(25, 0);
        this.mv.visitMethodInsn(184, TARGET, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.capReturn();
        }
        this.mv.visitInsn(opcode);
    }

    private void capReturn() {
        Type tp = this.returnType;
        if (tp == null || tp.equals(Type.VOID_TYPE)) {
            this.mv.visitInsn(1);
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, TARGET, END_METHOD, END_METHOD_DESC, false);
            return;
        }
        switch (tp.getSort()) {
            case 7: 
            case 8: {
                this.mv.visitInsn(92);
                break;
            }
            default: {
                this.mv.visitInsn(89);
            }
        }
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitInsn(1);
        this.mv.visitMethodInsn(184, TARGET, END_METHOD, END_METHOD_DESC, false);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitInsn(1);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TARGET, END_METHOD, END_METHOD_DESC, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

