/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.asm.IASM;
import scouter.agent.asm.asyncsupport.CallRunnableCV;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.util.StringUtil;

public class CallRunnableASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();
    private static final Set<String> callRunnableMap = new HashSet<String>();
    private static List<String> scanScopePrefix;

    public CallRunnableASM() {
        if (this.conf.hook_spring_async_enabled) {
            scanScopePrefix.add("org/springframework/aop/interceptor/AsyncExecutionInterceptor");
            scanScopePrefix.add("reactor/core/publisher/Mono");
            scanScopePrefix.add("reactor/core/publisher/Flux");
        }
        if (this.conf.hook_async_callrunnable_enabled) {
            String[] prefixes = StringUtil.split(this.conf.hook_async_callrunnable_scan_package_prefixes, ',');
            for (int i = 0; i < prefixes.length; ++i) {
                Logger.println("Callable Runnable scan scope : " + prefixes[i]);
                scanScopePrefix.add(prefixes[i].replace('.', '/'));
            }
        }
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        String[] interfaces = classDesc.interfaces;
        for (int inx = 0; inx < interfaces.length; ++inx) {
            if (!callRunnableMap.contains(interfaces[inx])) continue;
            for (int jnx = 0; jnx < scanScopePrefix.size(); ++jnx) {
                if (className.indexOf(scanScopePrefix.get(jnx)) != 0) continue;
                return new CallRunnableCV(cv, className);
            }
        }
        return cv;
    }

    static {
        callRunnableMap.add("java/util/concurrent/Callable");
        callRunnableMap.add("java/lang/Runnable");
        callRunnableMap.add("reactor/core/publisher/MonoCallable");
        callRunnableMap.add("reactor/core/publisher/MonoRunnable");
        callRunnableMap.add("reactor/core/publisher/MonoSupplier");
        callRunnableMap.add("reactor/core/publisher/FluxCallable");
        scanScopePrefix = new ArrayList<String>();
    }
}

