/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.jdbc;

import java.util.HashSet;
import java.util.Set;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.TraceSQL;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

public class StExecuteMV
extends LocalVariablesSorter
implements Opcodes {
    private static Set<String> target = new HashSet<String>();
    private final Type returnType;
    private final byte methodType;
    private static final String TRACESQL;
    private static final String START_METHOD = "start";
    private static final String START_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/String;B)Ljava/lang/Object;";
    private static final String END_METHOD = "end";
    private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Throwable;I)V";
    private Label startFinally = new Label();
    private int statIdx;
    private String desc;

    public static boolean isTarget(String name) {
        return target.contains(name);
    }

    public StExecuteMV(int access, String desc, MethodVisitor mv, String owner, String name) {
        super(524288, access, desc, mv);
        this.returnType = Type.getReturnType(desc);
        this.desc = desc;
        this.methodType = StExecuteMV.methodType(name);
    }

    public static byte methodType(String name) {
        if ("execute".equals(name)) {
            return 16;
        }
        if ("executeQuery".equals(name)) {
            return 48;
        }
        if ("executeUpdate".equals(name)) {
            return 32;
        }
        return 0;
    }

    @Override
    public void visitCode() {
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        AsmUtil.PUSH(this.mv, this.methodType);
        this.mv.visitMethodInsn(184, TRACESQL, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            switch (this.returnType.getSort()) {
                case 9: {
                    if (this.returnType.getElementType().getSort() == 5) {
                        int lvPosReturn = this.newLocal(this.returnType);
                        this.mv.visitVarInsn(58, lvPosReturn);
                        this.mv.visitVarInsn(25, lvPosReturn);
                        this.mv.visitVarInsn(25, this.statIdx);
                        this.mv.visitInsn(1);
                        this.mv.visitVarInsn(25, lvPosReturn);
                        this.mv.visitMethodInsn(184, TRACESQL, "getIntArraySum", "([I)I", false);
                        break;
                    }
                    this.mv.visitVarInsn(25, this.statIdx);
                    this.mv.visitInsn(1);
                    AsmUtil.PUSH(this.mv, -1);
                    break;
                }
                case 1: 
                case 5: {
                    int i = this.newLocal(this.returnType);
                    this.mv.visitVarInsn(54, i);
                    this.mv.visitVarInsn(21, i);
                    this.mv.visitVarInsn(25, this.statIdx);
                    this.mv.visitInsn(1);
                    this.mv.visitVarInsn(21, i);
                    if (this.returnType.getSort() != 1) break;
                    this.mv.visitMethodInsn(184, TRACESQL, "toInt", "(Z)I", false);
                    break;
                }
                default: {
                    this.mv.visitVarInsn(25, this.statIdx);
                    this.mv.visitInsn(1);
                    AsmUtil.PUSH(this.mv, -1);
                }
            }
            this.mv.visitMethodInsn(184, TRACESQL, END_METHOD, END_SIGNATURE, false);
        }
        this.mv.visitInsn(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitVarInsn(25, errIdx);
        AsmUtil.PUSH(this.mv, -3);
        this.mv.visitMethodInsn(184, TRACESQL, END_METHOD, END_SIGNATURE, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }

    static {
        target.add("execute");
        target.add("executeQuery");
        target.add("executeUpdate");
        target.add("executeBatch");
        TRACESQL = TraceSQL.class.getName().replace('.', '/');
    }
}

