/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.counter.meter.MeterResource;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.DecimalValue;
import scouter.util.SysJMX;

public class GCInfo {
    public MeterResource gcCountInfo = new MeterResource();
    public MeterResource gcTimeInfo = new MeterResource();
    public MeterResource cpuTimeInfo = new MeterResource();
    private long[] oldGc = null;
    private long oldCpu = 0L;

    @Counter
    public void getGCInfo(CounterBasket pw) {
        long[] gcInfo = SysJMX.getCurrentProcGcInfo();
        if (this.oldGc == null) {
            this.oldGc = gcInfo;
            return;
        }
        long dCount = gcInfo[0] - this.oldGc[0];
        long dTime = gcInfo[1] - this.oldGc[1];
        this.oldGc = gcInfo;
        this.gcCountInfo.add(dCount);
        this.gcTimeInfo.add(dTime);
        PerfCounterPack p = pw.getPack((byte)1);
        p.put("GcCount", new DecimalValue(dCount));
        p.put("GcTime", new DecimalValue(dTime));
        p = pw.getPack((byte)3);
        p.put("GcCount", new DecimalValue((long)this.gcCountInfo.getSum(300)));
        p.put("GcTime", new DecimalValue((long)this.gcTimeInfo.getSum(300)));
    }

    @Counter
    public void cpuTime(CounterBasket pw) {
        if (!SysJMX.isProcessCPU()) {
            return;
        }
        long cpu = SysJMX.getProcessCPU();
        if (this.oldCpu <= 0L) {
            this.oldCpu = cpu;
            return;
        }
        long dTime = cpu - this.oldCpu;
        this.oldCpu = cpu;
        this.cpuTimeInfo.add(dTime);
        PerfCounterPack p = pw.getPack((byte)1);
        p.put("CpuTime", new DecimalValue(dTime));
        p = pw.getPack((byte)3);
        p.put("CpuTime", new DecimalValue((long)this.cpuTimeInfo.getSum(300)));
    }
}

