/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import scouter.agent.Logger;
import scouter.agent.proxy.IReactiveSupport;
import scouter.agent.proxy.LoaderManager;
import scouter.agent.trace.TraceContext;

public class ReactiveSupportFactory {
    private static final String REACTIVE_SUPPORT = "scouter.xtra.reactive.ReactiveSupport";
    public static final IReactiveSupport dummy = new IReactiveSupport(){

        @Override
        public Object subscriptOnContext(Object mono0, TraceContext traceContext) {
            return mono0;
        }

        @Override
        public void contextOperatorHook() {
        }

        @Override
        public Object monoCoroutineContextHook(Object coroutineContext, TraceContext traceContext) {
            return coroutineContext;
        }

        @Override
        public String dumpScannable(TraceContext traceContext, TraceContext.TimedScannable timedScannable, long now) {
            return null;
        }
    };

    public static IReactiveSupport create(ClassLoader parent) {
        try {
            ClassLoader loader = LoaderManager.getReactiveClient(parent);
            if (loader == null) {
                return dummy;
            }
            Class<?> c = Class.forName(REACTIVE_SUPPORT, true, loader);
            return (IReactiveSupport)c.newInstance();
        }
        catch (Throwable e) {
            Logger.println("A133-1", "fail to create", e);
            return dummy;
        }
    }
}

