/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.plugin.PluginHttpCallTrace;
import scouter.agent.proxy.IHttpClient;
import scouter.agent.proxy.WebClientFactory;
import scouter.agent.trace.ApiCallTransferMap;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.LocalContext;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ApiCallTraceHelper;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallStep2;
import scouter.util.Hexa32;
import scouter.util.IntKeyLinkedMap;
import scouter.util.KeyGen;

public class ForWebClient
implements ApiCallTraceHelper.IHelper {
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(10);
    private static Configure conf = Configure.getInstance();
    private boolean ok = true;

    @Override
    public ApiCallStep process(TraceContext ctx, HookArgs hookPoint) {
        ApiCallStep2 step = new ApiCallStep2();
        ctx.apicall_name = hookPoint.class1;
        if (this.ok) {
            try {
                if (hookPoint.args != null && hookPoint.args.length > 0) {
                    ApiCallTransferMap.put(System.identityHashCode(hookPoint.args[0]), ctx, step);
                    ApiCallTransferMap.put(System.identityHashCode(hookPoint.this1), ctx, step);
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
        }
        return step;
    }

    public void processInfo(Object bodyInserter, Object clientHttpRequest) {
        if (bodyInserter == null) {
            return;
        }
        int bodyInserterHash = System.identityHashCode(bodyInserter);
        ApiCallTransferMap.ID id = ApiCallTransferMap.get(bodyInserterHash);
        if (id == null) {
            return;
        }
        ApiCallTransferMap.remove(bodyInserterHash);
        TraceContext ctx = id.ctx;
        ApiCallStep2 step = id.step;
        if (this.ok) {
            try {
                IHttpClient httpclient = this.getProxy(clientHttpRequest);
                String host = httpclient.getHost(clientHttpRequest);
                step.opt = 1;
                step.address = host;
                if (host != null) {
                    ctx.apicall_target = host;
                }
                ctx.apicall_name = httpclient.getURI(clientHttpRequest);
                step.txid = KeyGen.next();
                this.transfer(httpclient, ctx, clientHttpRequest, step.txid);
            }
            catch (Exception e) {
                this.ok = false;
            }
        }
    }

    @Override
    public void processEnd(TraceContext ctx, ApiCallStep step, Object rtn, HookArgs hookPoint) {
    }

    public LocalContext processEnd(Object exchangeFunction, Object clientHttpResponse) {
        int exchangeFunctionHash = System.identityHashCode(exchangeFunction);
        ApiCallTransferMap.ID id = ApiCallTransferMap.get(exchangeFunctionHash);
        if (id == null) {
            return null;
        }
        ApiCallTransferMap.remove(exchangeFunctionHash);
        TraceContext ctx = id.ctx;
        ApiCallStep2 step = id.step;
        IHttpClient httpclient = this.getProxy(exchangeFunction);
        String calleeObjHashStr = httpclient.getResponseHeader(clientHttpResponse, ForWebClient.conf._trace_interservice_callee_obj_header_key);
        if (calleeObjHashStr != null) {
            try {
                ctx.lastCalleeObjHash = Integer.parseInt(calleeObjHashStr);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            ctx.lastCalleeObjHash = 0;
        }
        return new LocalContext(ctx, step, httpclient.getResponseStatusCode(clientHttpResponse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(Object _this) {
        int key = System.identityHashCode(_this.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForWebClient forWebClient = this;
            synchronized (forWebClient) {
                httpclient = WebClientFactory.create(_this.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }

    private void transfer(IHttpClient httpclient, TraceContext ctx, Object req, long calleeTxid) {
        if (ForWebClient.conf.trace_interservice_enabled) {
            try {
                if (ctx.gxid == 0L) {
                    ctx.gxid = ctx.txid;
                }
                httpclient.addHeader(req, ForWebClient.conf._trace_interservice_gxid_header_key, Hexa32.toString32(ctx.gxid));
                httpclient.addHeader(req, ForWebClient.conf._trace_interservice_caller_header_key, Hexa32.toString32(ctx.txid));
                httpclient.addHeader(req, ForWebClient.conf._trace_interservice_callee_header_key, Hexa32.toString32(calleeTxid));
                httpclient.addHeader(req, ForWebClient.conf._trace_interservice_caller_obj_header_key, String.valueOf(conf.getObjHash()));
                httpclient.addHeader(req, "x-b3-traceid", Hexa32.toUnsignedLongHex(ctx.gxid));
                httpclient.addHeader(req, "x-b3-parentspanid", Hexa32.toUnsignedLongHex(ctx.txid));
                httpclient.addHeader(req, "x-b3-spanid", Hexa32.toUnsignedLongHex(calleeTxid));
                PluginHttpCallTrace.call(ctx, req);
            }
            catch (Exception e) {
                Logger.println("A178w", e);
                this.ok = false;
            }
        }
    }
}

