/*
 * Decompiled with CFR 0.152.
 */
package scouter.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.PackEnum;
import scouter.lang.step.Step;
import scouter.lang.step.StepEnum;
import scouter.lang.value.Value;
import scouter.lang.value.ValueEnum;

public class DataInputX {
    public static Long LONG5_MAX_VALUE = 0x7FFFFFFF00L;
    private int offset;
    private DataInput inner;
    private DataInputStream din;

    public DataInputX(byte[] buff) {
        this(new ByteArrayInputStream(buff));
    }

    public DataInputX(byte[] buff, int offset) {
        this(new ByteArrayInputStream(buff, offset, buff.length - offset));
    }

    public DataInputX(ByteArrayInputStream in) {
        this(new DataInputStream(in));
    }

    public DataInputX(BufferedInputStream in) {
        this.din = new DataInputStream(in);
        this.inner = this.din;
    }

    public DataInputX(DataInputStream in) {
        this.inner = in;
        this.din = in;
    }

    public DataInputX(RandomAccessFile in) {
        this.inner = in;
    }

    public byte[] readIntBytes() throws IOException {
        int len = this.readInt();
        return this.read(len);
    }

    public byte[] read(int len) throws IOException {
        this.offset += len;
        byte[] buff = new byte[len];
        this.inner.readFully(buff);
        return buff;
    }

    public byte[] readShortBytes() throws IOException {
        int len = this.readUnsignedShort();
        this.offset += len;
        byte[] buff = new byte[len];
        this.inner.readFully(buff);
        return buff;
    }

    public byte[] readBlob() throws IOException {
        int baselen = this.readUnsignedByte();
        switch (baselen) {
            case 255: {
                int len = this.readUnsignedShort();
                byte[] buffer = this.read(len);
                return buffer;
            }
            case 254: {
                int len = this.readInt();
                byte[] buffer = this.read(len);
                return buffer;
            }
            case 0: {
                return new byte[0];
            }
        }
        byte[] buffer = this.read(baselen);
        return buffer;
    }

    public int readInt3() throws IOException {
        byte[] readBuffer = this.read(3);
        return DataInputX.toInt3(readBuffer, 0);
    }

    public long readLong5() throws IOException {
        byte[] readBuffer = this.read(5);
        return DataInputX.toLong5(readBuffer, 0);
    }

    public long readDecimal() throws IOException {
        byte len = this.readByte();
        switch (len) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 3: {
                return this.readInt3();
            }
            case 4: {
                return this.readInt();
            }
            case 5: {
                return this.readLong5();
            }
        }
        return this.readLong();
    }

    public String readText() throws IOException {
        byte[] buffer = this.readBlob();
        return new String(buffer, "UTF8");
    }

    public static boolean toBoolean(byte[] buf, int pos) {
        return buf[pos] != 0;
    }

    public static short toShort(byte[] buf, int pos) {
        int ch1 = buf[pos] & 0xFF;
        int ch2 = buf[pos + 1] & 0xFF;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public static int toInt3(byte[] buf, int pos) {
        int ch1 = buf[pos] & 0xFF;
        int ch2 = buf[pos + 1] & 0xFF;
        int ch3 = buf[pos + 2] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) >> 8;
    }

    public static int toInt(byte[] buf, int pos) {
        int ch1 = buf[pos] & 0xFF;
        int ch2 = buf[pos + 1] & 0xFF;
        int ch3 = buf[pos + 2] & 0xFF;
        int ch4 = buf[pos + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long toLong(byte[] buf, int pos) {
        return ((long)buf[pos] << 56) + ((long)(buf[pos + 1] & 0xFF) << 48) + ((long)(buf[pos + 2] & 0xFF) << 40) + ((long)(buf[pos + 3] & 0xFF) << 32) + ((long)(buf[pos + 4] & 0xFF) << 24) + (long)((buf[pos + 5] & 0xFF) << 16) + (long)((buf[pos + 6] & 0xFF) << 8) + (long)((buf[pos + 7] & 0xFF) << 0);
    }

    public static long toLong5(byte[] buf, int pos) {
        return ((long)buf[pos] << 32) + ((long)(buf[pos + 1] & 0xFF) << 24) + (long)((buf[pos + 2] & 0xFF) << 16) + (long)((buf[pos + 3] & 0xFF) << 8) + (long)((buf[pos + 4] & 0xFF) << 0);
    }

    public static float toFloat(byte[] buf, int pos) {
        return Float.intBitsToFloat(DataInputX.toInt(buf, pos));
    }

    public static double toDouble(byte[] buf, int pos) {
        return Double.longBitsToDouble(DataInputX.toLong(buf, pos));
    }

    public static byte[] get(byte[] buf, int pos, int length) {
        byte[] out = new byte[length];
        System.arraycopy(buf, pos, out, 0, length);
        return out;
    }

    public int[] readDecimalArray(int[] data) throws IOException {
        int length = (int)this.readDecimal();
        data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (int)this.readDecimal();
        }
        return data;
    }

    public long[] readDecimalArray() throws IOException {
        int length = (int)this.readDecimal();
        long[] data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.readDecimal();
        }
        return data;
    }

    public long[] readArray() throws IOException {
        return this.readArray(new long[0]);
    }

    public long[] readArray(long[] data) throws IOException {
        int length = this.readShort();
        data = new long[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.readLong();
        }
        return data;
    }

    public int[] readArray(int[] data) throws IOException {
        int length = this.readShort();
        data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.readInt();
        }
        return data;
    }

    public float[] readArray(float[] data) throws IOException {
        int length = this.readShort();
        data = new float[length];
        for (int i = 0; i < length; ++i) {
            data[i] = this.readFloat();
        }
        return data;
    }

    public Value readValue() throws IOException {
        ++this.offset;
        byte type = this.inner.readByte();
        return ValueEnum.create(type).read(this);
    }

    public Step readStep() throws IOException {
        ++this.offset;
        byte type = this.inner.readByte();
        return StepEnum.create(type).read(this);
    }

    public Pack readPack() throws IOException {
        ++this.offset;
        byte type = this.inner.readByte();
        return PackEnum.create(type).read(this);
    }

    public MapPack readMapPack() throws IOException {
        return (MapPack)this.readPack();
    }

    public void readFully(byte[] b) throws IOException {
        this.offset += b.length;
        this.inner.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.offset += len;
        this.inner.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        this.offset += n;
        return this.inner.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        ++this.offset;
        return this.inner.readBoolean();
    }

    public byte readByte() throws IOException {
        ++this.offset;
        return this.inner.readByte();
    }

    public int readUnsignedByte() throws IOException {
        ++this.offset;
        return this.inner.readUnsignedByte();
    }

    public short readShort() throws IOException {
        this.offset += 2;
        return this.inner.readShort();
    }

    public int readUnsignedShort() throws IOException {
        this.offset += 2;
        return this.inner.readUnsignedShort();
    }

    public char readChar() throws IOException {
        this.offset += 2;
        return this.inner.readChar();
    }

    public int readInt() throws IOException {
        this.offset += 4;
        return this.inner.readInt();
    }

    public long readLong() throws IOException {
        this.offset += 8;
        return this.inner.readLong();
    }

    public float readFloat() throws IOException {
        this.offset += 4;
        return this.inner.readFloat();
    }

    public double readDouble() throws IOException {
        this.offset += 8;
        return this.inner.readDouble();
    }

    public int available() throws IOException {
        return this.din == null ? 0 : this.din.available();
    }

    public void close() throws IOException {
        if (this.inner instanceof RandomAccessFile) {
            ((RandomAccessFile)this.inner).close();
        } else if (this.inner instanceof InputStream) {
            ((InputStream)((Object)this.inner)).close();
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public static byte[] read(FileChannel channel, int len) throws IOException {
        byte[] buf = new byte[len];
        ByteBuffer dst = ByteBuffer.wrap(buf);
        channel.read(dst);
        return buf;
    }
}

