/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.value.MapValue;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class AlertPack
implements Pack {
    public static String HASH_FLAG = "_hash_";
    public long time;
    public String objType;
    public int objHash;
    public byte level;
    public String title;
    public String message;
    public MapValue tags = new MapValue();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALERT ");
        sb.append(DateUtil.timestamp(this.time));
        sb.append(" objType=").append(this.objType);
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" level=").append(this.level);
        sb.append(" title=").append(this.title);
        sb.append(" message=").append(this.message);
        sb.append(" tags=").append(this.tags);
        return sb.toString();
    }

    @Override
    public byte getPackType() {
        return 70;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeLong(this.time);
        dout.writeByte(this.level);
        dout.writeText(this.objType);
        dout.writeInt(this.objHash);
        dout.writeText(this.title);
        dout.writeText(this.message);
        dout.writeValue(this.tags);
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        this.time = din.readLong();
        this.level = din.readByte();
        this.objType = din.readText();
        this.objHash = din.readInt();
        this.title = din.readText();
        this.message = din.readText();
        this.tags = (MapValue)din.readValue();
        return this;
    }
}

