/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.TimeTypeEnum;
import scouter.lang.pack.Pack;
import scouter.lang.value.FloatValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.NumberValue;
import scouter.lang.value.Value;
import scouter.util.DateUtil;

public class PerfCounterPack
implements Pack {
    public long time;
    public String objName;
    public byte timetype;
    public MapValue data = new MapValue();

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PerfCounter ").append(DateUtil.timestamp(this.time));
        buf.append(" ").append(this.objName);
        buf.append(" ").append(TimeTypeEnum.getString(this.timetype));
        buf.append(" ").append(this.data);
        return buf.toString();
    }

    @Override
    public byte getPackType() {
        return 60;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeLong(this.time);
        dout.writeText(this.objName);
        dout.writeByte(this.timetype);
        dout.writeValue(this.data);
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        this.time = din.readLong();
        this.objName = din.readText();
        this.timetype = din.readByte();
        this.data = (MapValue)din.readValue();
        return this;
    }

    public void put(String key, Object o) {
        if (o instanceof Number) {
            this.data.put(key, new FloatValue(((Number)o).floatValue()));
        }
    }

    public void put(String key, Value value) {
        this.data.put(key, value);
    }

    public void add(String key, NumberValue value) {
        Value old = this.data.get(key);
        if (old == null) {
            this.data.put(key, value);
        } else if (old instanceof NumberValue) {
            ((NumberValue)old).add(value);
        }
    }
}

