/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

public class SpanTypes {
    public static final byte CLIENT = 0;
    public static final byte SERVER = 1;
    public static final byte PRODUCER = 2;
    public static final byte CONSUMER = 3;
    public static final byte UNKNOWN = 99;

    public static boolean isXLoggable(byte typeByte) {
        Type type = Type.of(typeByte);
        return type == Type.SERVER || type == Type.CONSUMER;
    }

    public static boolean isApiable(byte typeByte) {
        Type type = Type.of(typeByte);
        return type == Type.CLIENT || type == Type.PRODUCER;
    }

    public static boolean isBoundary(byte typeByte) {
        Type type = Type.of(typeByte);
        return type == Type.SERVER || type == Type.CONSUMER || type == Type.CLIENT || type == Type.PRODUCER;
    }

    public static boolean isParentXLoggable(byte typeByte) {
        Type type = Type.of(typeByte);
        return type == Type.SERVER || type == Type.CONSUMER || type == Type.CLIENT || type == Type.PRODUCER;
    }

    public static boolean isXLoggable(Type type) {
        return type == Type.SERVER || type == Type.CONSUMER;
    }

    public static boolean isApiable(Type type) {
        return type == Type.CLIENT || type == Type.PRODUCER;
    }

    public static enum Type {
        CLIENT(0),
        SERVER(1),
        PRODUCER(2),
        CONSUMER(3),
        UNKNOWN(99);

        byte value;

        private Type(byte value) {
            this.value = value;
        }

        public static Type of(byte value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

