/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.ByteArrayEnumer;
import scouter.util.CompareUtil;

public class ByteArrayKeyLinkedMap<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private ByteArrayKeyLinkedEntry<V>[] table;
    private ByteArrayKeyLinkedEntry<V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int max;

    public ByteArrayKeyLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new ByteArrayKeyLinkedEntry[initCapacity];
        this.header = new ByteArrayKeyLinkedEntry<Object>(new byte[0], null, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public ByteArrayKeyLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public byte[][] keyArray() {
        byte[][] _keys = new byte[this.size()][];
        ByteArrayEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextKey();
        }
        return _keys;
    }

    public synchronized ByteArrayEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<ByteArrayKeyLinkedEntry<V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        ByteArrayKeyLinkedEntry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            ByteArrayKeyLinkedEntry<V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(byte[] key) {
        ByteArrayKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized V get(byte[] key) {
        ByteArrayKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized byte[] getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized byte[] getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized V getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized V getLastValue() {
        return this.header.link_prev.value;
    }

    protected void overflowed(byte[] key, V value) {
    }

    protected V create(byte[] key) {
        throw new RuntimeException("not implemented create()");
    }

    public V intern(byte[] key) {
        return this._intern(key, MODE.LAST);
    }

    private synchronized V _intern(byte[] key, MODE m) {
        ByteArrayKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        V value = this.create(key);
        if (value == null) {
            return null;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    byte[] k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    byte[] k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        ByteArrayKeyLinkedEntry<V> e2 = new ByteArrayKeyLinkedEntry<V>(key, value, tab[index]);
        tab[index] = e2;
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e2);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e2);
            }
        }
        ++this.count;
        return value;
    }

    private int hash(byte[] key) {
        return Arrays.hashCode(key) & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        ByteArrayKeyLinkedEntry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        ByteArrayKeyLinkedEntry[] newMap = new ByteArrayKeyLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            ByteArrayKeyLinkedEntry<V> old = oldMap[i];
            while (old != null) {
                ByteArrayKeyLinkedEntry<V> e = old;
                old = old.next;
                byte[] key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public ByteArrayKeyLinkedMap<V> setMax(int max) {
        this.max = max;
        return this;
    }

    public V put(byte[] key, V value) {
        return this._put(key, value, MODE.LAST);
    }

    public V putLast(byte[] key, V value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public V putFirst(byte[] key, V value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized V _put(byte[] key, V value, MODE m) {
        ByteArrayKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyLinkedEntry<V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                Object old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    byte[] k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    byte[] k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        V v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new ByteArrayKeyLinkedEntry<V>(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    public synchronized V remove(byte[] key) {
        ByteArrayKeyLinkedEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyLinkedEntry<V> e = tab[index];
        ByteArrayKeyLinkedEntry<V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized V removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized V removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        ByteArrayKeyLinkedEntry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ByteArrayKeyLinkedEntry<V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            ByteArrayKeyLinkedEntry<V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Arrays.toString(e.getKey()) + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ByteArrayKeyLinkedEntry<V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            ByteArrayKeyLinkedEntry<V> e = it.nextElement();
            buf.append("\t").append(Arrays.toString(e.getKey()) + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(ByteArrayKeyLinkedEntry link_prev, ByteArrayKeyLinkedEntry link_next, ByteArrayKeyLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(ByteArrayKeyLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(Comparator<ByteArrayKeyLinkedEntry<V>> c) {
        ArrayList<ByteArrayKeyLinkedEntry<V>> list = new ArrayList<ByteArrayKeyLinkedEntry<V>>(this.size());
        Enumeration<ByteArrayKeyLinkedEntry<V>> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            ByteArrayKeyLinkedEntry e = (ByteArrayKeyLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static void main(String[] args) {
        ByteArrayKeyLinkedMap<Integer> m = new ByteArrayKeyLinkedMap<Integer>();
        for (int i = 0; i < 10; ++i) {
            byte[] b = new byte[]{new Byte(String.valueOf(i))};
            m.put(b, i);
        }
        System.out.println(m);
        m.sort(new Comparator<ByteArrayKeyLinkedEntry<Integer>>(){

            @Override
            public int compare(ByteArrayKeyLinkedEntry<Integer> o1, ByteArrayKeyLinkedEntry<Integer> o2) {
                return CompareUtil.compareTo(o2.getKey(), o1.getKey());
            }
        });
        System.out.println(m);
    }

    public static class ByteArrayKeyLinkedEntry<V> {
        byte[] key;
        V value;
        ByteArrayKeyLinkedEntry<V> next;
        ByteArrayKeyLinkedEntry<V> link_next;
        ByteArrayKeyLinkedEntry<V> link_prev;

        protected ByteArrayKeyLinkedEntry(byte[] key, V value, ByteArrayKeyLinkedEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new ByteArrayKeyLinkedEntry<V>(this.key, this.value, this.next == null ? null : (ByteArrayKeyLinkedEntry)this.next.clone());
        }

        public byte[] getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByteArrayKeyLinkedEntry)) {
                return false;
            }
            ByteArrayKeyLinkedEntry e = (ByteArrayKeyLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class Enumer<V>
    implements Enumeration,
    ByteArrayEnumer {
        TYPE type;
        ByteArrayKeyLinkedEntry entry;

        Enumer(TYPE type) {
            this.entry = ((ByteArrayKeyLinkedMap)ByteArrayKeyLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return ByteArrayKeyLinkedMap.this.header != this.entry && this.entry != null;
        }

        public V nextElement() {
            if (this.hasMoreElements()) {
                ByteArrayKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return (V)e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public byte[] nextKey() {
            if (this.hasMoreElements()) {
                ByteArrayKeyLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

