/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.FloatEnumer;
import scouter.util.IntEnumer;

public class IntFloatMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntFloatEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;

    public IntFloatMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public IntFloatMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntFloatEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntFloatMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized FloatEnumer values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<IntFloatEntry> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(int value) {
        IntFloatEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntFloatEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(Float.valueOf(e.value), (Object)value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntFloatEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        h = h ^ h >>> 7 ^ h >>> 4;
        return h & Integer.MAX_VALUE;
    }

    public synchronized float get(int key) {
        IntFloatEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntFloatEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntFloatEntry[] newMap = new IntFloatEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntFloatEntry old = oldMap[i];
            while (old != null) {
                IntFloatEntry e = old;
                old = old.next;
                int index = this.hash(e.key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public synchronized float[] valueArray() {
        float[] _values = new float[this.size()];
        FloatEnumer en = this.values();
        for (int i = 0; i < _values.length; ++i) {
            _values[i] = en.nextFloat();
        }
        return _values;
    }

    public synchronized float put(int key, float value) {
        IntFloatEntry[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        IntFloatEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                float old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = _hash % tab.length;
        }
        tab[index] = e = new IntFloatEntry(key, value, tab[index]);
        ++this.count;
        return this.NONE;
    }

    public synchronized float remove(int key) {
        IntFloatEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntFloatEntry e = tab[index];
        IntFloatEntry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                float oldValue = e.value;
                e.value = this.NONE;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized void clear() {
        IntFloatEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntFloatEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntFloatEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntFloatEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntFloatEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public void putAll(IntFloatMap other) {
        Enumeration<IntFloatEntry> it = other.entries();
        int max = other.size();
        for (int i = 0; i <= max; ++i) {
            IntFloatEntry e = it.nextElement();
            this.put(e.getKey(), e.getValue());
        }
    }

    private class Enumer
    implements Enumeration,
    IntEnumer,
    FloatEnumer {
        IntFloatEntry[] table;
        int index;
        IntFloatEntry entry;
        IntFloatEntry lastReturned;
        TYPE type;

        Enumer(TYPE type) {
            this.table = IntFloatMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntFloatEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return Float.valueOf(e.value);
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntFloatEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                }
                return IntFloatMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public float nextFloat() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                IntFloatEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case VALUES: {
                        return e.value;
                    }
                }
                return IntFloatMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    public static class IntFloatEntry {
        int key;
        float value;
        IntFloatEntry next;

        protected IntFloatEntry(int key, float value, IntFloatEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new IntFloatEntry(this.key, this.value, this.next == null ? null : (IntFloatEntry)this.next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public float getValue() {
            return this.value;
        }

        public float setValue(float value) {
            float oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntFloatEntry)) {
                return false;
            }
            IntFloatEntry e = (IntFloatEntry)o;
            return this.key == e.getKey() && this.value == e.getValue();
        }

        public int hashCode() {
            return this.key ^ (int)this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

