/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.IntEnumer;
import scouter.util.StringEnumer;

public class StringIntMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringIntEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;

    public StringIntMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringIntEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringIntMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public StringIntMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized IntEnumer values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<StringIntEntry> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(int value) {
        StringIntEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            StringIntEntry e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        StringIntEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringIntEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized int get(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringIntEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringIntEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringIntEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringIntEntry[] newMap = new StringIntEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringIntEntry old = oldMap[i];
            while (old != null) {
                StringIntEntry e = old;
                old = old.next;
                int index = (e.key.hashCode() & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized int put(String key, int value) {
        if (key == null) {
            return this.NONE;
        }
        StringIntEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringIntEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                int old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new StringIntEntry(key, value, tab[index]);
        ++this.count;
        return this.NONE;
    }

    public synchronized int add(String key, int value) {
        if (key == null) {
            return this.NONE;
        }
        StringIntEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringIntEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                int old = e.value;
                e.value += value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new StringIntEntry(key, value, tab[index]);
        ++this.count;
        return this.NONE;
    }

    public synchronized int remove(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringIntEntry[] tab = this.table;
        int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
        StringIntEntry e = tab[index];
        StringIntEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                int oldValue = e.value;
                e.value = this.NONE;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized void clear() {
        StringIntEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringIntEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            StringIntEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringIntEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            StringIntEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public static void main(String[] args) {
    }

    private class Enumer
    implements Enumeration,
    StringEnumer,
    IntEnumer {
        StringIntEntry[] table;
        int index;
        StringIntEntry entry;
        StringIntEntry lastReturned;
        TYPE type;

        Enumer(TYPE type) {
            this.table = StringIntMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                StringIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                StringIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case VALUES: {
                        return e.value;
                    }
                }
                return StringIntMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public String nextString() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                StringIntEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                }
                return null;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    public static class StringIntEntry {
        String key;
        int value;
        StringIntEntry next;

        protected StringIntEntry(String key, int value, StringIntEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new StringIntEntry(this.key, this.value, this.next == null ? null : (StringIntEntry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringIntEntry)) {
                return false;
            }
            StringIntEntry e = (StringIntEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

