/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.meter;

import scouter.lang.ref.INT;
import scouter.lang.ref.LONG;
import scouter.util.MeteringUtil;

public class MeterInteraction {
    private String interactionType;
    private String interactionName;
    private MeteringUtil<Bucket> meter = new MeteringUtil<Bucket>(){

        @Override
        protected Bucket create() {
            return new Bucket();
        }

        @Override
        protected void clear(Bucket o) {
            o.count = 0;
            o.error = 0;
            o.time = 0L;
        }
    };

    public MeterInteraction(String interactionType, String interactionName) {
        this.interactionType = interactionType;
        this.interactionName = interactionName;
    }

    public String getInteractionName() {
        return this.interactionName;
    }

    public synchronized void add(int elapsed, boolean err) {
        Bucket b = this.meter.getCurrentBucket();
        ++b.count;
        b.time += (long)elapsed;
        if (err) {
            ++b.error;
        }
    }

    public float getTps(int period) {
        final INT sum = new INT();
        period = this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.count;
            }
        });
        return (float)((double)sum.value / (double)period);
    }

    public int getAvgTime(int period) {
        final LONG sum = new LONG();
        final INT cnt = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.time;
                cnt.value += b.count;
            }
        });
        return (int)(cnt.value == 0 ? 0L : sum.value / (long)cnt.value);
    }

    public long getSumTime(int period) {
        final LONG sum = new LONG();
        period = this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.time;
            }
        });
        return sum.value;
    }

    public int getCount(int period) {
        final INT sum = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.count;
            }
        });
        return sum.value;
    }

    public int getErrorCount(int period) {
        final INT sum = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                sum.value += b.error;
            }
        });
        return sum.value;
    }

    public float getErrorRate(int period) {
        final INT cnt = new INT();
        final INT err = new INT();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket b) {
                cnt.value += b.count;
                err.value += b.error;
            }
        });
        return (float)(cnt.value == 0 ? 0.0 : (double)err.value / (double)cnt.value * 100.0);
    }

    static final class Bucket {
        int count;
        long time;
        int error;

        Bucket() {
        }
    }
}

