/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.task;

import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.counter.jmx.LazyPlatformMBeanServer;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.FloatValue;
import scouter.util.StringEnumer;
import scouter.util.StringSet;
import scouter.util.StringUtil;

public class CustomJmx {
    Configure conf = Configure.getInstance();
    LazyPlatformMBeanServer mBeanServer;
    boolean mBeanServerEnable = true;

    @Counter
    public void extractJmx(CounterBasket pw) {
        if (!this.conf.counter_custom_jmx_enabled || !this.mBeanServerEnable) {
            return;
        }
        StringSet nameSet = this.conf.getCustomJmxSet();
        if (nameSet.size() < 1) {
            return;
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = LazyPlatformMBeanServer.create();
        }
        try {
            if (this.mBeanServer.checkInit()) {
                StringEnumer stringEnumer = nameSet.keys();
                PerfCounterPack pack = pw.getPack((byte)1);
                while (stringEnumer.hasMoreElements()) {
                    float value;
                    String next = stringEnumer.nextString();
                    String[] mbeanAndAttribute = StringUtil.split(next, "|");
                    if (mbeanAndAttribute.length != 3 || !((value = this.mBeanServer.getValue(mbeanAndAttribute[1], mbeanAndAttribute[2])) >= 0.0f)) continue;
                    pack.put(mbeanAndAttribute[0], new FloatValue(value));
                }
            }
        }
        catch (Exception e) {
            Logger.println("SC-555", e.getMessage(), e);
            this.mBeanServerEnable = false;
        }
    }
}

