/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.enumeration.ParameterizedMessageLevel;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.util.StringUtil;

public class ParameterizedMessageStep
extends StepSingle {
    private static char delimETX = (char)3;
    private int hash;
    private int elapsed = -1;
    private byte level = 0;
    private String paramString;
    private transient Map<String, String> tempMap = new HashMap<String, String>();

    @Override
    public byte getStepType() {
        return 17;
    }

    public String toString() {
        return "ParameterizedMessageStep " + this.hash;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        super.write(out);
        out.writeDecimal(this.hash);
        out.writeDecimal(this.elapsed);
        out.writeDecimal(this.level);
        out.writeText(this.paramString);
    }

    @Override
    public Step read(DataInputX in) throws IOException {
        super.read(in);
        this.hash = (int)in.readDecimal();
        this.elapsed = (int)in.readDecimal();
        this.level = (byte)in.readDecimal();
        this.paramString = in.readText();
        return this;
    }

    public int getHash() {
        return this.hash;
    }

    public void setHash(int hash) {
        this.hash = hash;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(int elapsed) {
        this.elapsed = elapsed;
    }

    public void setLevel(ParameterizedMessageLevel level) {
        this.level = level.getLevel();
    }

    public void setLevelOfByte(byte level) {
        this.level = level;
    }

    public ParameterizedMessageLevel getLevel() {
        return ParameterizedMessageLevel.of(this.level);
    }

    public void putTempMessage(String key, String message) {
        this.tempMap.put(key, message);
    }

    public String getTempMessage(String key) {
        return this.tempMap.get(key);
    }

    public void setMessage(int hash, String ... params) {
        this.hash = hash;
        StringBuilder sb = new StringBuilder();
        for (String param : params) {
            sb.append(param).append(delimETX);
        }
        this.paramString = sb.toString();
    }

    public String buildMessasge(String messageFormat) {
        String[] params = null;
        try {
            if (this.paramString == null) {
                return messageFormat;
            }
            params = StringUtil.split(this.paramString, delimETX);
            if (params.length == 0) {
                return messageFormat;
            }
            return String.format(messageFormat, params);
        }
        catch (Exception e) {
            return messageFormat;
        }
    }
}

