/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import scouter.agent.Configure;
import scouter.util.CompareUtil;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.IClose;
import scouter.util.StringLongLinkedMap;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public class Logger {
    private static StringLongLinkedMap lastLog = new StringLongLinkedMap().setMax(1000);
    static Configure conf = Configure.getInstance();
    static PrintWriter pw = null;
    static File logfile = null;
    static Runnable initializer = new Runnable(){
        long last = System.currentTimeMillis();
        long lastDataUnit = DateUtil.getDateUnit();
        String lastDir;
        boolean lastFileRotation;
        String scouter_name;
        {
            this.lastDir = Logger.conf.log_dir;
            this.lastFileRotation = Logger.conf.log_rotation_enabled;
            this.scouter_name = "boot";
        }

        @Override
        public void run() {
            try {
                this.process();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private synchronized void process() {
            long now = System.currentTimeMillis();
            if (now > this.last + 3600000L) {
                this.last = now;
                Logger.clearOldLog();
            }
            if (!CompareUtil.equals(this.lastDir, Logger.conf.log_dir) || this.lastFileRotation != Logger.conf.log_rotation_enabled || this.lastDataUnit != DateUtil.getDateUnit() || !this.scouter_name.equals(Logger.conf.obj_name) || logfile != null && !logfile.exists()) {
                pw = (PrintWriter)FileUtil.close(pw);
                logfile = null;
                this.lastDir = Logger.conf.log_dir;
                this.lastFileRotation = Logger.conf.log_rotation_enabled;
                this.lastDataUnit = DateUtil.getDateUnit();
                this.scouter_name = Logger.conf.obj_name;
            }
            try {
                Logger.openFile(this.scouter_name);
            }
            catch (Throwable t) {
                Logger.sysout(t.getMessage());
            }
        }
    };

    public static void println(Object message) {
        Logger.println(Logger.build("SCOUTER", Logger.toString(message)), true);
    }

    public static void println(String id, Object message) {
        if (!Logger.checkOk(id, 0)) {
            return;
        }
        Logger.println(Logger.build(id, Logger.toString(message)), true);
    }

    public static void println(String id, String message, Throwable t) {
        if (!Logger.checkOk(id, 10)) {
            return;
        }
        Logger.println(Logger.build(id, message), true);
        Logger.println(ThreadUtil.getStackTrace(t), true);
    }

    public static void trace(Object message) {
        if (Logger.conf._trace) {
            if (Logger.conf._trace_use_logger) {
                Logger.println(Logger.build("SCOUTER-TRC", Logger.toString(message)), true);
            } else {
                System.out.println(Logger.build("SCOUTER-TRC", Logger.toString(message)));
            }
        }
    }

    private static String toString(Object message) {
        return message == null ? "null" : message.toString();
    }

    private static String build(String id, String message) {
        if (message == null) {
            message = "null-err-message";
        }
        return new StringBuffer(20 + id.length() + message.length()).append(DateUtil.datetime(System.currentTimeMillis())).append(" [").append(id).append("] ").append(message).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCallStack(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }

    private static boolean checkOk(String id, int sec) {
        if (Configure.getInstance().isIgnoreLog(id)) {
            return false;
        }
        if (sec > 0) {
            long last = lastLog.get(id);
            long now = System.currentTimeMillis();
            if (now < last + (long)(sec * 1000)) {
                return false;
            }
            lastLog.put(id, now);
        }
        return true;
    }

    private static void println(String msg, boolean sysout) {
        block4: {
            try {
                if (pw != null) {
                    pw.println(msg);
                    pw.flush();
                    return;
                }
                if (sysout) {
                    System.out.println(msg);
                }
            }
            catch (Throwable e) {
                pw = (PrintWriter)FileUtil.close(pw);
                if (!sysout) break block4;
                System.out.println(msg);
            }
        }
    }

    private static synchronized void openFile(String prefix) throws IOException {
        if (pw == null && !StringUtil.isEmpty(Logger.conf.log_dir)) {
            File root = new File(Logger.conf.log_dir);
            if (!root.canWrite()) {
                root.mkdirs();
            }
            if (!root.canWrite()) {
                return;
            }
            if (Logger.conf.log_rotation_enabled) {
                File file = new File(Logger.conf.log_dir, "scouter-" + prefix + "-" + DateUtil.yyyymmdd() + ".log");
                FileWriter fw = new FileWriter(file, true);
                pw = new PrintWriter(fw);
                logfile = file;
            } else {
                File file = new File(Logger.conf.log_dir, "scouter-" + prefix + ".log");
                pw = new PrintWriter(new FileWriter(file, true));
                logfile = file;
            }
        }
    }

    protected static void clearOldLog() {
        if (!Logger.conf.log_rotation_enabled) {
            return;
        }
        if (Logger.conf.log_keep_days <= 0) {
            return;
        }
        String scouter_prefix = "scouter-" + Logger.conf.obj_name;
        long nowUnit = DateUtil.getDateUnit();
        File dir = new File(Logger.conf.log_dir);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String date;
            int x;
            String name;
            if (files[i].isDirectory() || !(name = files[i].getName()).startsWith(scouter_prefix + "-") || (x = name.lastIndexOf(46)) < 0 || (date = name.substring(scouter_prefix.length() + 1, x)).length() != 8) continue;
            try {
                long d = DateUtil.yyyymmdd(date);
                long fileUnit = DateUtil.getDateUnit(d);
                if (nowUnit - fileUnit <= (long)Logger.conf.log_keep_days) continue;
                files[i].delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        String name = "scouter-19701123.log";
        int x = name.lastIndexOf(46);
        String date = name.substring("scouter-".length(), x);
        System.out.println(date);
    }

    public static void info(String message) {
        message = Logger.build("SCOUTER", message);
        Logger.sysout(message);
        Logger.println(message, false);
    }

    private static void sysout(String message) {
        System.out.println(message);
    }

    public static class FileLog
    implements IClose {
        private PrintWriter out;

        public FileLog(String filename) {
            try {
                this.out = new PrintWriter(new FileWriter(filename));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void println(String message) {
            if (this.out == null) {
                return;
            }
            this.out.println(DateUtil.datetime(System.currentTimeMillis()) + " " + message);
            this.out.flush();
        }

        @Override
        public void close() {
            FileUtil.close(this.out);
        }
    }
}

