/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.jdbc;

import scouter.agent.Logger;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.SqlParameter;
import scouter.agent.trace.TraceSQL;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

public class PsInitMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACESQL = TraceSQL.class.getName().replace('.', '/');
    private static final String METHOD = "prepare";
    private static final String SIGNATURE = "(Ljava/lang/Object;Lscouter/agent/trace/SqlParameter;Ljava/lang/String;)V";
    private static final String METHOD_INIT = "stmtInit";
    private static final String SIGNATURE_INIT = "(Ljava/lang/Object;)V";
    private String owner;
    private int sqlIdx = -1;
    private boolean isUstatement = false;

    public PsInitMV(int access, String desc, MethodVisitor mv, String owner) {
        super(589824, access, desc, mv);
        this.owner = owner;
        this.sqlIdx = AsmUtil.getStringIdx(access, desc);
        if (this.sqlIdx < 0) {
            this.sqlIdx = AsmUtil.getIdxByType(access, desc, Type.getType("Lcubrid/jdbc/jci/UStatement;"));
            Logger.trace("CUBRID PSTMT LOAD - " + this.sqlIdx);
            this.isUstatement = true;
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.sqlIdx >= 0 && opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, TRACESQL, METHOD_INIT, SIGNATURE_INIT, false);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.owner, "_param_", "Lscouter/agent/trace/SqlParameter;");
            Label end = new Label();
            this.mv.visitJumpInsn(199, end);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitTypeInsn(187, Type.getInternalName(SqlParameter.class));
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, Type.getInternalName(SqlParameter.class), "<init>", "()V", false);
            this.mv.visitFieldInsn(181, this.owner, "_param_", "Lscouter/agent/trace/SqlParameter;");
            this.mv.visitLabel(end);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, this.owner, "_param_", "Lscouter/agent/trace/SqlParameter;");
            this.mv.visitVarInsn(25, this.sqlIdx);
            if (this.isUstatement) {
                this.mv.visitMethodInsn(182, "cubrid/jdbc/jci/UStatement", "getQuery", "()Ljava/lang/String;", false);
            }
            this.mv.visitMethodInsn(184, TRACESQL, METHOD, SIGNATURE, false);
        }
        this.mv.visitInsn(opcode);
    }
}

