/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.extra.java20;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class ThreadDumps {
    public static List<String> threadDumpWithVirtualThread(boolean json) {
        HotSpotDiagnosticMXBean platformMXBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
        try {
            String suffix = ".dump";
            HotSpotDiagnosticMXBean.ThreadDumpFormat format = HotSpotDiagnosticMXBean.ThreadDumpFormat.TEXT_PLAIN;
            if (json) {
                suffix = ".jsondump";
                format = HotSpotDiagnosticMXBean.ThreadDumpFormat.JSON;
            }
            Path temp = Files.createTempFile("scouterdump_", "_vthread", new FileAttribute[0]);
            String dumpFilePath = temp.toString() + suffix;
            platformMXBean.dumpThreads(dumpFilePath, format);
            Path path = Paths.get(dumpFilePath, new String[0]);
            List<String> dumpByLine = Files.readAllLines(path);
            try {
                temp.toFile().deleteOnExit();
                path.toFile().deleteOnExit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dumpByLine;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

