/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.plugin.AbstractAppService;
import scouter.agent.plugin.AbstractCapture;
import scouter.agent.plugin.AbstractCounter;
import scouter.agent.plugin.AbstractHttpCall;
import scouter.agent.plugin.AbstractHttpService;
import scouter.agent.plugin.AbstractJdbcPool;
import scouter.agent.plugin.PluginAppServiceTrace;
import scouter.agent.plugin.PluginBackThreadTrace;
import scouter.agent.plugin.PluginCaptureTrace;
import scouter.agent.plugin.PluginCounter;
import scouter.agent.plugin.PluginHttpCallTrace;
import scouter.agent.plugin.PluginHttpServiceTrace;
import scouter.agent.plugin.PluginJdbcPoolTrace;
import scouter.agent.plugin.PluginSpringControllerCaptureTrace;
import scouter.agent.plugin.WrContext;
import scouter.agent.plugin.WrHttpCallRequest;
import scouter.agent.plugin.WrRequest;
import scouter.agent.plugin.WrResponse;
import scouter.agent.plugin.Wrapper;
import scouter.agent.plugin.impl.Neighbor;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.HookReturn;
import scouter.agent.trace.TraceSQL;
import scouter.javassist.CannotCompileException;
import scouter.javassist.ClassPool;
import scouter.javassist.CtClass;
import scouter.javassist.CtMethod;
import scouter.javassist.CtNewMethod;
import scouter.javassist.NotFoundException;
import scouter.lang.pack.PerfCounterPack;
import scouter.util.FileUtil;
import scouter.util.Hexa32;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;

public class PluginLoader
extends Thread {
    private static final Set<String> registeredJarOnCp = Collections.synchronizedSet(new HashSet());
    private static PluginLoader instance;
    private long IHttpServiceCompile;
    private long IServiceTraceCompile;
    private long ICaptureCompile;
    private long IJdbcPoolCompile;
    private long IHttpCallCompile;
    private long ICounterCompile;

    public static synchronized PluginLoader getInstance() {
        if (instance == null) {
            instance = new PluginLoader();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(PluginLoader.class));
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            try {
                File root = Configure.getInstance().plugin_dir;
                this.reloadIfModified(root);
            }
            catch (Throwable t) {
                Logger.println("A160", t.toString());
            }
            ThreadUtil.sleep(5000L);
        }
    }

    private void reloadIfModified(File root) {
        if (!Configure.getInstance().plugin_enabled) {
            return;
        }
        File script = new File(root, "service.plug");
        if (!script.canRead()) {
            PluginAppServiceTrace.plugIn = null;
        } else if (PluginAppServiceTrace.plugIn == null || PluginAppServiceTrace.plugIn.lastModified != script.lastModified()) {
            PluginAppServiceTrace.plugIn = this.createAppService(script);
        }
        script = new File(root, "httpservice.plug");
        if (!script.canRead()) {
            PluginHttpServiceTrace.plugIn = null;
        } else if (PluginHttpServiceTrace.plugIn == null || PluginHttpServiceTrace.plugIn.lastModified != script.lastModified()) {
            PluginHttpServiceTrace.plugIn = this.createHttpService(script);
        }
        script = new File(root, "backthread.plug");
        if (!script.canRead()) {
            PluginBackThreadTrace.plugIn = null;
        } else if (PluginBackThreadTrace.plugIn == null || PluginBackThreadTrace.plugIn.lastModified != script.lastModified()) {
            PluginBackThreadTrace.plugIn = this.createAppService(script);
        }
        script = new File(root, "capture.plug");
        if (!script.canRead()) {
            PluginCaptureTrace.plugIn = null;
        } else if (PluginCaptureTrace.plugIn == null || PluginCaptureTrace.plugIn.lastModified != script.lastModified()) {
            PluginCaptureTrace.plugIn = this.createICaptureTrace(script);
        }
        script = new File(root, "springControllerCapture.plug");
        if (!script.canRead()) {
            PluginSpringControllerCaptureTrace.plugIn = null;
        } else if (PluginSpringControllerCaptureTrace.plugIn == null || PluginSpringControllerCaptureTrace.plugIn.lastModified != script.lastModified()) {
            PluginSpringControllerCaptureTrace.plugIn = this.createICaptureTrace(script);
        }
        script = new File(root, "jdbcpool.plug");
        if (!script.canRead()) {
            PluginJdbcPoolTrace.plugIn = null;
        } else if ((PluginJdbcPoolTrace.plugIn == null || PluginJdbcPoolTrace.plugIn.lastModified != script.lastModified()) && (PluginJdbcPoolTrace.plugIn = this.createIJdbcPool(script)) != null) {
            TraceSQL.clearUrlMap();
        }
        script = new File(root, "httpcall.plug");
        if (!script.canRead()) {
            PluginHttpCallTrace.plugIn = null;
        } else if (PluginHttpCallTrace.plugIn == null || PluginHttpCallTrace.plugIn.lastModified != script.lastModified()) {
            PluginHttpCallTrace.plugIn = this.createIHttpCall(script);
        }
        script = new File(root, "counter.plug");
        if (!script.canRead()) {
            PluginCounter.plugIn = null;
        } else if (PluginCounter.plugIn == null || PluginCounter.plugIn.lastModified != script.lastModified()) {
            PluginCounter.plugIn = this.createCounter(script);
        }
    }

    private AbstractHttpService createHttpService(File script) {
        if (this.IHttpServiceCompile == script.lastModified()) {
            return null;
        }
        this.IHttpServiceCompile = script.lastModified();
        try {
            HashMap<String, StringBuffer> bodyTable = this.loadFileText(script);
            String superName = AbstractHttpService.class.getName();
            String className = "scouter.agent.plugin.impl.HttpServiceImpl";
            String METHOD_START = "start";
            String METHOD_END = "end";
            String METHOD_REJECT = "reject";
            String SIGNATURE = this.nativeName(WrContext.class) + this.nativeName(WrRequest.class) + this.nativeName(WrResponse.class);
            String METHOD_P1 = WrContext.class.getName();
            String METHOD_P2 = WrRequest.class.getName();
            String METHOD_P3 = WrResponse.class.getName();
            if (!bodyTable.containsKey(METHOD_START)) {
                throw new CannotCompileException("no method body: " + METHOD_START);
            }
            if (!bodyTable.containsKey(METHOD_END)) {
                throw new CannotCompileException("no method body: " + METHOD_END);
            }
            if (!bodyTable.containsKey(METHOD_REJECT)) {
                throw new CannotCompileException("no method body: " + METHOD_REJECT);
            }
            ClassPool cp = ClassPool.getDefault();
            String jar = FileUtil.getJarFileName(PluginLoader.class);
            String logName = "createHttpService";
            PluginLoader.appendClasspath(cp, jar, logName);
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            CtMethod method_start = null;
            CtMethod method_end = null;
            CtMethod method_reject = null;
            StringBuilder sb = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                method_start = impl.getMethod(METHOD_START, "(" + SIGNATURE + ")V");
                method_end = impl.getMethod(METHOD_END, "(" + SIGNATURE + ")V");
                method_reject = impl.getMethod(METHOD_REJECT, "(" + SIGNATURE + ")Z");
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                StringBuilder sb1 = new StringBuilder();
                sb1.append(METHOD_P1).append(" p1").append(",");
                sb1.append(METHOD_P2).append(" p2").append(",");
                sb1.append(METHOD_P3).append(" p3");
                sb = new StringBuilder();
                sb.append("public void ").append(METHOD_START).append("(").append((CharSequence)sb1).append("){}");
                method_start = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_start);
                sb = new StringBuilder();
                sb.append("public void ").append(METHOD_END).append("(").append((CharSequence)sb1).append("){}");
                method_end = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_end);
                sb = new StringBuilder();
                sb.append("public boolean ").append(METHOD_REJECT).append("(").append((CharSequence)sb1).append("){return false;}");
                method_reject = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_reject);
            }
            StringBuilder bodyPrefix = new StringBuilder();
            bodyPrefix.append("{");
            bodyPrefix.append(METHOD_P1).append(" $ctx=$1;");
            bodyPrefix.append(METHOD_P2).append(" $req=$2;");
            bodyPrefix.append(METHOD_P3).append(" $res=$3;");
            method_start.setBody(bodyPrefix + bodyTable.get(METHOD_START) + "\n}");
            method_end.setBody(bodyPrefix + bodyTable.get(METHOD_END) + "\n}");
            method_reject.setBody(bodyPrefix + bodyTable.get(METHOD_REJECT) + "\n}");
            Class<?> c = this.toClass(impl);
            AbstractHttpService plugin = (AbstractHttpService)c.newInstance();
            plugin.lastModified = script.lastModified();
            Logger.println("PLUG-IN : " + AbstractHttpService.class.getName() + " " + script.getName() + " loaded #" + Hexa32.toString32(plugin.hashCode()));
            return plugin;
        }
        catch (CannotCompileException ee) {
            Logger.println("PLUG-IN : " + ee.getMessage());
        }
        catch (Throwable e) {
            Logger.println("A161", e.getMessage(), e);
        }
        return null;
    }

    private HashMap<String, StringBuffer> loadFileText(File script) {
        StringBuffer sb = new StringBuffer();
        HashMap<String, StringBuffer> result = new HashMap<String, StringBuffer>();
        String txt = new String(FileUtil.readAll(script));
        try {
            String line;
            BufferedReader r = new BufferedReader(new StringReader(txt));
            while ((line = StringUtil.trim(r.readLine())) != null) {
                if (line.startsWith("[") && line.endsWith("]")) {
                    sb = new StringBuffer();
                    result.put(line.substring(1, line.length() - 1), sb);
                    continue;
                }
                sb.append(line).append("\n");
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private AbstractAppService createAppService(File script) {
        if (this.IServiceTraceCompile == script.lastModified()) {
            return null;
        }
        this.IServiceTraceCompile = script.lastModified();
        try {
            StringBuffer sb;
            HashMap<String, StringBuffer> bodyTable = this.loadFileText(script);
            String superName = AbstractAppService.class.getName();
            String className = "scouter.agent.plugin.impl.ServiceTraceImpl";
            String START = "start";
            String START_SIG = "(" + this.nativeName(WrContext.class) + this.nativeName(HookArgs.class) + ")V";
            String START_P1 = WrContext.class.getName();
            String START_P2 = HookArgs.class.getName();
            StringBuffer START_BODY = bodyTable.get(START);
            if (START_BODY == null) {
                throw new CannotCompileException("no method body: " + START);
            }
            String END = "end";
            String END_SIG = "(" + this.nativeName(WrContext.class) + ")V";
            String END_P1 = WrContext.class.getName();
            StringBuffer END_BODY = bodyTable.get(END);
            if (END_BODY == null) {
                throw new CannotCompileException("no method body: " + END);
            }
            ClassPool cp = ClassPool.getDefault();
            String jar = FileUtil.getJarFileName(PluginLoader.class);
            String logName = "createAppService";
            PluginLoader.appendClasspath(cp, jar, logName);
            Class<?> c = null;
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            CtMethod method_start = null;
            CtMethod method_end = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                method_start = impl.getMethod(START, START_SIG);
                method_end = impl.getMethod(END, END_SIG);
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                sb = new StringBuffer();
                sb.append("public void ").append(START).append("(");
                sb.append(START_P1).append(" p1 ").append(",");
                sb.append(START_P2).append(" p2");
                sb.append("){}");
                method_start = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_start);
                sb = new StringBuffer();
                sb.append("public void ").append(END).append("(");
                sb.append(END_P1).append(" p1 ");
                sb.append("){}");
                method_end = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_end);
            }
            sb = new StringBuffer();
            sb.append("{");
            sb.append(START_P1).append(" $ctx=$1;");
            sb.append(START_P2).append(" $hook=$2;");
            sb.append(START_BODY);
            sb.append("\n}");
            method_start.setBody(sb.toString());
            sb = new StringBuffer();
            sb.append("{");
            sb.append(END_P1).append(" $ctx=$1;");
            sb.append(END_BODY);
            sb.append("\n}");
            method_end.setBody(sb.toString());
            c = impl.toClass(Wrapper.class.getClassLoader(), Wrapper.class.getProtectionDomain());
            AbstractAppService plugin = (AbstractAppService)c.newInstance();
            plugin.lastModified = script.lastModified();
            Logger.println("PLUG-IN : " + AbstractAppService.class.getName() + " " + script.getName() + " loaded #" + Hexa32.toString32(plugin.hashCode()));
            return plugin;
        }
        catch (CannotCompileException ee) {
            Logger.println("PLUG-IN : " + ee.getMessage());
        }
        catch (Exception e) {
            Logger.println("A162", e);
        }
        return null;
    }

    private AbstractCapture createICaptureTrace(File script) {
        if (this.ICaptureCompile == script.lastModified()) {
            return null;
        }
        this.ICaptureCompile = script.lastModified();
        try {
            StringBuffer sb;
            CtMethod method_this;
            CtMethod method_return;
            CtMethod method_args;
            HashMap<String, StringBuffer> bodyTable = this.loadFileText(script);
            String superName = AbstractCapture.class.getName();
            String className = "scouter.agent.plugin.impl.CaptureImpl";
            String ARG = "capArgs";
            String ARG_SIG = "(" + this.nativeName(WrContext.class) + this.nativeName(HookArgs.class) + ")V";
            String ARG_P1 = WrContext.class.getName();
            String ARG_P2 = HookArgs.class.getName();
            StringBuffer ARG_BODY = bodyTable.get("args");
            String RTN = "capReturn";
            String RTN_SIG = "(" + this.nativeName(WrContext.class) + this.nativeName(HookReturn.class) + ")V";
            String RTN_P1 = WrContext.class.getName();
            String RTN_P2 = HookReturn.class.getName();
            StringBuffer RTN_BODY = bodyTable.get("return");
            String THIS = "capThis";
            String THIS_SIG = "(" + this.nativeName(WrContext.class) + this.nativeName(String.class) + this.nativeName(String.class) + this.nativeName(Object.class) + ")V";
            String THIS_P1 = WrContext.class.getName();
            String THIS_P2 = String.class.getName();
            String THIS_P3 = String.class.getName();
            String THIS_P4 = "Object";
            StringBuffer THIS_BODY = bodyTable.get("this");
            ClassPool cp = ClassPool.getDefault();
            String jar = FileUtil.getJarFileName(PluginLoader.class);
            String logName = "createICaptureTrace";
            PluginLoader.appendClasspath(cp, jar, logName);
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                method_args = impl.getMethod(ARG, ARG_SIG);
                method_return = impl.getMethod(RTN, RTN_SIG);
                method_this = impl.getMethod(THIS, THIS_SIG);
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                sb = new StringBuffer();
                sb.append("public void ").append(ARG).append("(");
                sb.append(ARG_P1).append(" p1 ").append(",");
                sb.append(ARG_P2).append(" p2 ");
                sb.append("){}");
                method_args = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_args);
                sb = new StringBuffer();
                sb.append("public void ").append(RTN).append("(");
                sb.append(RTN_P1).append(" p1 ").append(",");
                sb.append(RTN_P2).append(" p2 ");
                sb.append("){}");
                method_return = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_return);
                sb = new StringBuffer();
                sb.append("public void ").append(THIS).append("(");
                sb.append(THIS_P1).append(" p1 ").append(",");
                sb.append(THIS_P2).append(" p2 ").append(",");
                sb.append(THIS_P3).append(" p3 ").append(",");
                sb.append(THIS_P4).append(" p4 ");
                sb.append("){}");
                method_this = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_this);
            }
            sb = new StringBuffer();
            sb.append("{");
            sb.append(ARG_P1).append(" $ctx=$1;");
            sb.append(ARG_P2).append(" $hook=$2;");
            sb.append(ARG_BODY);
            sb.append("\n}");
            method_args.setBody(sb.toString());
            sb = new StringBuffer();
            sb.append("{");
            sb.append(RTN_P1).append(" $ctx=$1;");
            sb.append(RTN_P2).append(" $hook=$2;");
            sb.append(RTN_BODY);
            sb.append("\n}");
            method_return.setBody(sb.toString());
            sb = new StringBuffer();
            sb.append("{");
            sb.append(THIS_P1).append(" $ctx=$1;");
            sb.append(THIS_P2).append(" $class=$2;");
            sb.append(THIS_P3).append(" $desc=$3;");
            sb.append(THIS_P4).append(" $this=$4;");
            sb.append(THIS_BODY);
            sb.append("\n}");
            method_this.setBody(sb.toString());
            Class<?> c = this.toClass(impl);
            AbstractCapture plugin = (AbstractCapture)c.newInstance();
            plugin.lastModified = script.lastModified();
            Logger.println("PLUG-IN : " + AbstractCapture.class.getName() + " " + script.getName() + " loaded #" + Hexa32.toString32(plugin.hashCode()));
            return plugin;
        }
        catch (CannotCompileException ee) {
            Logger.println("PLUG-IN : " + ee.getMessage());
        }
        catch (Exception e) {
            Logger.println("A905", e);
        }
        return null;
    }

    private AbstractJdbcPool createIJdbcPool(File script) {
        if (this.IJdbcPoolCompile == script.lastModified()) {
            return null;
        }
        this.IJdbcPoolCompile = script.lastModified();
        try {
            HashMap<String, StringBuffer> bodyTable = this.loadFileText(script);
            String superName = AbstractJdbcPool.class.getName();
            String className = "scouter.agent.plugin.impl.JdbcPoolImpl";
            String URL2 = "url";
            String URL_SIG = "(" + this.nativeName(WrContext.class) + this.nativeName(String.class) + this.nativeName(Object.class) + ")" + this.nativeName(String.class);
            String URL_P1 = WrContext.class.getName();
            String URL_P2 = String.class.getName();
            String URL_P3 = "Object";
            StringBuffer URL_BODY = bodyTable.get("url");
            ClassPool cp = ClassPool.getDefault();
            String jar = FileUtil.getJarFileName(PluginLoader.class);
            String logName = "createIJdbcPool";
            PluginLoader.appendClasspath(cp, jar, logName);
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            CtMethod method = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                method = impl.getMethod(URL2, URL_SIG);
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                StringBuffer sb = new StringBuffer();
                sb.append("public String ").append(URL2).append("(");
                sb.append(URL_P1).append(" p1 ").append(",");
                sb.append(URL_P2).append(" p2 ").append(",");
                sb.append(URL_P3).append(" p3 ");
                sb.append("){return null;}");
                method = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            sb.append(URL_P1).append(" $ctx=$1;");
            sb.append(URL_P2).append(" $msg=$2;");
            sb.append(URL_P3).append(" $pool=$3;");
            sb.append(URL_BODY);
            sb.append("\n}");
            method.setBody(sb.toString());
            Class<?> c = this.toClass(impl);
            AbstractJdbcPool plugin = (AbstractJdbcPool)c.newInstance();
            plugin.lastModified = script.lastModified();
            Logger.println("PLUG-IN : " + AbstractJdbcPool.class.getName() + " " + script.getName() + " loaded #" + Hexa32.toString32(plugin.hashCode()));
            return plugin;
        }
        catch (CannotCompileException ee) {
            Logger.println("PLUG-IN : " + ee.getMessage());
        }
        catch (Exception e) {
            Logger.println("A906", e);
        }
        return null;
    }

    private AbstractHttpCall createIHttpCall(File script) {
        if (this.IHttpCallCompile == script.lastModified()) {
            return null;
        }
        this.IHttpCallCompile = script.lastModified();
        try {
            StringBuffer sb;
            HashMap<String, StringBuffer> bodyTable = this.loadFileText(script);
            String superName = AbstractHttpCall.class.getName();
            String className = "scouter.agent.plugin.impl.IHttCallTraceImpl";
            String CALL = "call";
            String CALL_SIG = "(" + this.nativeName(WrContext.class) + this.nativeName(WrHttpCallRequest.class) + ")V";
            String CALL_P1 = WrContext.class.getName();
            String CALL_P2 = WrHttpCallRequest.class.getName();
            StringBuffer CALL_BODY = bodyTable.get(CALL);
            if (CALL_BODY == null) {
                throw new CannotCompileException("no method body: " + CALL);
            }
            ClassPool cp = ClassPool.getDefault();
            String jar = FileUtil.getJarFileName(PluginLoader.class);
            String logName = "createIHttpCall";
            PluginLoader.appendClasspath(cp, jar, logName);
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            CtMethod method = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                method = impl.getMethod(CALL, CALL_SIG);
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                sb = new StringBuffer();
                sb.append("public void ").append(CALL).append("(");
                sb.append(CALL_P1).append(" p1 ").append(",");
                sb.append(CALL_P2).append(" p2");
                sb.append("){}");
                method = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method);
            }
            sb = new StringBuffer();
            sb.append("{");
            sb.append(CALL_P1).append(" $ctx=$1;");
            sb.append(CALL_P2).append(" $req=$2;");
            sb.append(CALL_BODY);
            sb.append("\n}");
            method.setBody(sb.toString());
            Class<?> c = this.toClass(impl);
            AbstractHttpCall plugin = (AbstractHttpCall)c.newInstance();
            plugin.lastModified = script.lastModified();
            Logger.println("PLUG-IN : " + AbstractHttpCall.class.getName() + " " + script.getName() + " loaded #" + Hexa32.toString32(plugin.hashCode()));
            return plugin;
        }
        catch (CannotCompileException ee) {
            Logger.println("PLUG-IN : " + ee.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.println("A907", e);
        }
        return null;
    }

    private AbstractCounter createCounter(File script) {
        if (this.ICounterCompile == script.lastModified()) {
            return null;
        }
        this.ICounterCompile = script.lastModified();
        try {
            HashMap<String, StringBuffer> bodyTable = this.loadFileText(script);
            String superName = AbstractCounter.class.getName();
            String className = "scouter.agent.plugin.impl.CounterImpl";
            String METHOD_COUNTER = "counter";
            String METHOD_SIGNATURE = "(" + this.nativeName(PerfCounterPack.class) + ")V";
            String METHOD_P1 = PerfCounterPack.class.getName();
            if (!bodyTable.containsKey(METHOD_COUNTER)) {
                throw new CannotCompileException("no method body: " + METHOD_COUNTER);
            }
            ClassPool cp = ClassPool.getDefault();
            String jar = FileUtil.getJarFileName(PluginLoader.class);
            String logName = "createCounter";
            PluginLoader.appendClasspath(cp, jar, logName);
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            CtMethod method_counter = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                method_counter = impl.getMethod(METHOD_COUNTER, METHOD_SIGNATURE);
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                StringBuffer sb = new StringBuffer();
                sb.append("public void ").append(METHOD_COUNTER).append("(").append(METHOD_P1).append(" p1){}");
                method_counter = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(method_counter);
            }
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append(METHOD_P1).append(" $pack=$1;");
            body.append(bodyTable.get(METHOD_COUNTER));
            body.append("\n}");
            method_counter.setBody(body.toString());
            Class<?> c = this.toClass(impl);
            AbstractCounter plugin = (AbstractCounter)c.newInstance();
            plugin.lastModified = script.lastModified();
            Logger.println("PLUG-IN : " + AbstractCounter.class.getName() + " " + script.getName() + " loaded #" + Hexa32.toString32(plugin.hashCode()));
            return plugin;
        }
        catch (CannotCompileException ee) {
            Logger.println("PLUG-IN : " + ee.getMessage());
        }
        catch (Throwable e) {
            Logger.println("A161", e);
        }
        return null;
    }

    private String nativeName(Class class1) {
        return "L" + class1.getName().replace('.', '/') + ";";
    }

    private Class<?> toClass(CtClass impl) throws CannotCompileException {
        Class<?> c;
        try {
            c = impl.toClass(Neighbor.class);
        }
        catch (Throwable t) {
            Logger.println("A1600", "error on toClass with javassist. try to fallback for java8 below. err:" + t.getMessage());
            c = impl.toClass(new URLClassLoader(new URL[0], this.getClass().getClassLoader()), null);
        }
        return c;
    }

    private static synchronized void appendClasspath(ClassPool cp, String jar, String logName) throws NotFoundException {
        if (jar != null && !registeredJarOnCp.contains(jar)) {
            registeredJarOnCp.add(jar);
            cp.appendClassPath(jar);
            Logger.trace("[TR001:" + logName + "] javassist CP classpath added: " + jar);
        }
    }
}

