/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import scouter.agent.Configure;
import scouter.agent.JavaAgent;
import scouter.agent.Logger;
import scouter.agent.extra.java20.ThreadDumps;
import scouter.agent.proxy.IToolsMain;
import scouter.agent.proxy.LoaderManager;
import scouter.agent.util.ModuleUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class ToolsMainFactory {
    private static final String TOOLS_MAIN = "scouter.xtra.tools.ToolsMain";
    private static boolean wasGrantedAccessToHSM = false;
    private static boolean isSupportVThreadDump = true;
    public static boolean activeStack = false;

    public static MapPack heaphisto(Pack param) throws Throwable {
        MapPack m = new MapPack();
        if (SystemUtil.IS_JAVA_1_5) {
            m.put("error", "Not supported java version : " + SystemUtil.JAVA_VERSION);
            return m;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            m.put("error", "Not supported java vendor : " + SystemUtil.JAVA_VENDOR);
            return m;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            return null;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            m.put("error", "Not supported java vendor : " + SystemUtil.JAVA_VENDOR);
            return m;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            ToolsMainFactory.checkGrantAccess(loader);
            List<String> out = toolsMain.heaphisto(0, 100000, "all");
            ListValue lv = m.newList("heaphisto");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
        }
        catch (Exception e) {
            m.put("error", e.getMessage());
        }
        return m;
    }

    public static void heaphisto(PrintWriter out) throws Throwable {
        if (SystemUtil.IS_JAVA_1_5) {
            return;
        }
        if (SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            return;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            ToolsMainFactory.checkGrantAccess(loader);
            toolsMain.heaphisto(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Pack threadDump(Pack param) throws Throwable {
        MapPack m = new MapPack();
        if (SystemUtil.IS_JAVA_1_5 || SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            List<String> out = ThreadUtil.getThreadDumpList();
            ListValue lv = m.newList("threadDump");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
            return m;
        }
        List<String> vthreadDump = ToolsMainFactory.getVthreadDump();
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            List<String> out = ThreadUtil.getThreadDumpList();
            ListValue lv = m.newList("threadDump");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
            ToolsMainFactory.appendVthreadDumpToLv(vthreadDump, lv);
            return m;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            ToolsMainFactory.checkGrantAccess(loader);
            List<String> out = toolsMain.threadDump(0, 100000);
            ListValue lv = m.newList("threadDump");
            for (int i = 0; i < out.size(); ++i) {
                lv.add(out.get(i));
            }
            ToolsMainFactory.appendVthreadDumpToLv(vthreadDump, lv);
        }
        catch (Exception e) {
            m.put("error", e.getMessage());
        }
        return m;
    }

    private static List<String> getVthreadDump() {
        if (!isSupportVThreadDump) {
            return Collections.emptyList();
        }
        try {
            return ThreadDumps.threadDumpWithVirtualThread(Configure.getInstance().thread_dump_json_format);
        }
        catch (Throwable t) {
            isSupportVThreadDump = false;
            if (!Configure.getInstance()._trace) {
                Logger.println("DUMP001", "error on vthrad dump: " + t.getMessage());
            } else {
                Logger.println("DUMP001", "error on vthrad dump: " + t.getMessage(), t);
            }
            return Collections.emptyList();
        }
    }

    private static void appendVthreadDumpToLv(List<String> vthreadDump, ListValue lv) {
        if (vthreadDump != null && !vthreadDump.isEmpty()) {
            lv.add("");
            lv.add("[[[[[[[[ dump include virtual thread ]]]]]]]]");
            lv.add("");
            for (int i = 0; i < vthreadDump.size(); ++i) {
                lv.add(vthreadDump.get(i));
            }
        }
    }

    public static synchronized void threadDump(PrintWriter out) throws Throwable {
        activeStack = true;
        if (SystemUtil.IS_JAVA_1_5 || SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            out.print(ThreadUtil.getThreadDump());
            return;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            out.print(ThreadUtil.getThreadDump());
            return;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            ToolsMainFactory.checkGrantAccess(loader);
            toolsMain.threadDump(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkGrantAccess(ClassLoader loader) {
        if (JavaAgent.isJava9plus() && !wasGrantedAccessToHSM) {
            try {
                ModuleUtil.grantAccess(JavaAgent.getInstrumentation(), TOOLS_MAIN, loader, "sun.tools.attach.HotSpotVirtualMachine", loader);
            }
            catch (Throwable th) {
                Logger.println("TOOLS-5", th.getMessage(), th);
            }
            finally {
                wasGrantedAccessToHSM = true;
            }
        }
    }
}

