/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.trace.IProfileCollector;
import scouter.agent.trace.TraceContext;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ApiCallSum;
import scouter.lang.step.MethodStep;
import scouter.lang.step.MethodSum;
import scouter.lang.step.SocketStep;
import scouter.lang.step.SocketSum;
import scouter.lang.step.SqlStep;
import scouter.lang.step.SqlSum;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.util.IntKeyMap;
import scouter.util.LongKeyMap;

public class ProfileSummary
implements IProfileCollector {
    private TraceContext context;
    protected IntKeyMap<Step> methods;
    protected IntKeyMap<Step> sqls;
    protected IntKeyMap<Step> apicalls;
    protected LongKeyMap<Step> sockets;
    protected int magindex = 0;
    protected int totalCount;

    public ProfileSummary(TraceContext context) {
        this.context = context;
    }

    protected void process() {
        ArrayList<Step> steps = new ArrayList<Step>(this.totalCount);
        this.toArray(this.methods, steps);
        this.toArray(this.sqls, steps);
        this.toArray(this.apicalls, steps);
        this.toArray(this.sockets, steps);
        this.totalCount = 0;
        DataProxy.sendProfile(steps, this.context);
    }

    private void toArray(IntKeyMap<Step> src, List<Step> out) {
        if (src == null) {
            return;
        }
        Enumeration<Step> en = src.values();
        int max = src.size();
        for (int i = 0; i < max; ++i) {
            out.add(en.nextElement());
        }
        src.clear();
    }

    private void toArray(LongKeyMap<Step> src, List<Step> out) {
        if (src == null) {
            return;
        }
        Enumeration<Step> en = src.values();
        int max = src.size();
        for (int i = 0; i < max; ++i) {
            out.add(en.nextElement());
        }
        src.clear();
    }

    private void toArray(List<Step> src, List<Step> out) {
        if (src == null) {
            return;
        }
        int max = src.size();
        for (int i = 0; i < max; ++i) {
            out.add(src.get(i));
        }
        src.clear();
    }

    @Override
    public void push(StepSingle ss) {
    }

    @Override
    public void add(StepSingle ss) {
        switch (ss.getStepType()) {
            case 1: {
                this.add((MethodStep)ss);
                break;
            }
            case 2: {
                this.add((SqlStep)ss);
                break;
            }
            case 6: {
                this.add((ApiCallStep)ss);
                break;
            }
            case 5: {
                this.add((SocketStep)ss);
            }
        }
    }

    @Override
    public void pop(StepSingle ss) {
        switch (ss.getStepType()) {
            case 1: 
            case 10: {
                this.add((MethodStep)ss);
                break;
            }
            case 2: 
            case 8: 
            case 16: {
                this.add((SqlStep)ss);
                break;
            }
            case 6: {
                this.add((ApiCallStep)ss);
            }
        }
    }

    protected void add(SocketStep m) {
        long skid;
        SocketSum sksum;
        if (this.sockets == null) {
            this.sockets = new LongKeyMap();
        }
        if ((sksum = (SocketSum)this.sockets.get(skid = m.getSocketId())) != null) {
            sksum.add(m.elapsed, sksum.error != 0);
            return;
        }
        if (this.totalCount >= 1024) {
            this.process();
        }
        sksum = new SocketSum();
        sksum.ipaddr = m.ipaddr;
        sksum.port = m.port;
        sksum.add(m.elapsed, sksum.error != 0);
        this.sockets.put(skid, sksum);
        ++this.totalCount;
    }

    protected void add(MethodStep m) {
        MethodSum msum;
        if (this.methods == null) {
            this.methods = new IntKeyMap();
        }
        if ((msum = (MethodSum)this.methods.get(m.hash)) != null) {
            msum.hash = m.hash;
            msum.add(m.elapsed, m.cputime);
            return;
        }
        if (this.totalCount >= 1024) {
            this.process();
        }
        msum = new MethodSum();
        msum.hash = m.hash;
        msum.add(m.elapsed, m.cputime);
        this.methods.put(m.hash, msum);
        ++this.totalCount;
    }

    protected void add(SqlStep ss) {
        SqlSum ssum;
        if (this.sqls == null) {
            this.sqls = new IntKeyMap();
        }
        if ((ssum = (SqlSum)this.sqls.get(ss.hash)) != null) {
            ssum.hash = ss.hash;
            if (ss.error == 0) {
                ssum.add(ss.elapsed, ss.cputime, ss.param);
            } else {
                ssum.addError(ss.elapsed, ss.cputime, ss.param);
            }
            return;
        }
        if (this.totalCount >= 1024) {
            this.process();
        }
        ssum = new SqlSum();
        ssum.hash = ss.hash;
        if (ss.error == 0) {
            ssum.add(ss.elapsed, ss.cputime, ss.param);
        } else {
            ssum.addError(ss.elapsed, ss.cputime, ss.param);
        }
        this.sqls.put(ss.hash, ssum);
        ++this.totalCount;
    }

    protected void add(ApiCallStep sc) {
        ApiCallSum scs;
        if (this.apicalls == null) {
            this.apicalls = new IntKeyMap();
        }
        if ((scs = (ApiCallSum)this.apicalls.get(sc.hash)) != null) {
            scs.hash = sc.hash;
            ++scs.count;
            scs.elapsed += (long)sc.elapsed;
            scs.cputime += (long)sc.cputime;
            if (sc.error != 0) {
                ++scs.error;
            }
            return;
        }
        if (this.totalCount >= 1024) {
            this.process();
        }
        scs = new ApiCallSum();
        scs.hash = sc.hash;
        scs.count = 1;
        scs.elapsed = sc.elapsed;
        scs.cputime = sc.cputime;
        if (sc.error != 0) {
            scs.error = 1;
        }
        this.apicalls.put(sc.hash, scs);
        ++this.totalCount;
    }

    @Override
    public void close(boolean ok) {
        if (ok && this.totalCount > 0) {
            this.process();
        }
    }
}

