/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import scouter.agent.Configure;
import scouter.util.StringUtil;

public class SqlParameter {
    private int MAX_SIZE;
    protected int count;
    protected String[] entry;
    protected String sql;

    public SqlParameter() {
        this.MAX_SIZE = Configure.getInstance()._trace_sql_parameter_max_count;
        this.count = 0;
        this.entry = new String[this.MAX_SIZE];
    }

    public SqlParameter(String sql) {
        this.MAX_SIZE = Configure.getInstance()._trace_sql_parameter_max_count;
        this.count = 0;
        this.entry = new String[this.MAX_SIZE];
        this.setSql(sql);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void put(int x, String value) {
        int inx = x - 1;
        if (this.MAX_SIZE <= inx || inx < 0) {
            return;
        }
        this.entry[inx] = value;
        if (inx >= this.count) {
            this.count = inx + 1;
        }
    }

    public String get(int x) {
        if (0 <= x && x < this.count) {
            return this.entry[x];
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (this.entry[i] == null) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(this.entry[i]);
        }
        return buf.toString();
    }

    public String getDelimiterList() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (buf.length() > 0) {
                buf.append("\u00a7");
            }
            buf.append(StringUtil.nullToEmpty(this.entry[i]));
        }
        return buf.toString();
    }

    public String toString(String prev) {
        StringBuffer buf = new StringBuffer();
        if (prev != null) {
            buf.append(prev);
            for (int i = 0; i < this.count; ++i) {
                if (this.entry[i] == null) continue;
                buf.append(",");
                buf.append(this.entry[i]);
            }
        } else {
            for (int i = 0; i < this.count; ++i) {
                if (this.entry[i] == null) continue;
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(this.entry[i]);
            }
        }
        return buf.toString();
    }

    public synchronized void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.entry[i] = null;
        }
        this.count = 0;
    }
}

