/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import scouter.agent.Configure;
import scouter.agent.JavaAgent;
import scouter.agent.Logger;
import scouter.agent.plugin.PluginHttpCallTrace;
import scouter.agent.proxy.IHttpClient;
import scouter.agent.proxy.JavaNetHttpFactory;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ApiCallTraceHelper;
import scouter.lang.step.ApiCallStep;
import scouter.util.Hexa32;
import scouter.util.KeyGen;

public class ForJavaNetHttpClient
implements ApiCallTraceHelper.IHelper {
    private static IHttpClient httpClient = null;
    private static Configure conf = Configure.getInstance();
    private boolean ok = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiCallStep process(TraceContext ctx, HookArgs hookPoint) {
        ApiCallStep step = new ApiCallStep();
        if (this.ok) {
            try {
                if (hookPoint.args != null && hookPoint.args.length > 0) {
                    IHttpClient httpclient = this.getProxy();
                    step.txid = ctx.lastCalleeId;
                    String host = httpclient.getHost(hookPoint.args[0]);
                    step.opt = 1;
                    step.address = host;
                    if (host != null) {
                        ctx.apicall_target = host;
                    }
                    ctx.apicall_name = httpclient.getURI(hookPoint.args[0]);
                }
            }
            catch (Exception e) {
                this.ok = false;
            }
            finally {
                ctx.lastCalleeId = 0L;
            }
        }
        if (ctx.apicall_name == null) {
            ctx.apicall_name = hookPoint.class1;
        }
        return step;
    }

    @Override
    public void processEnd(TraceContext ctx, ApiCallStep step, Object rtn, HookArgs hookPoint) {
        IHttpClient httpclient = this.getProxy();
        String calleeObjHashStr = httpclient.getResponseHeader(rtn, ForJavaNetHttpClient.conf._trace_interservice_callee_obj_header_key);
        if (calleeObjHashStr != null) {
            try {
                ctx.lastCalleeObjHash = Integer.parseInt(calleeObjHashStr);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            ctx.lastCalleeObjHash = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy() {
        if (httpClient == null) {
            ForJavaNetHttpClient forJavaNetHttpClient = this;
            synchronized (forJavaNetHttpClient) {
                if (httpClient == null) {
                    httpClient = JavaNetHttpFactory.create(JavaAgent.getPlatformClassLoader());
                }
            }
        }
        return httpClient;
    }

    void transfer(TraceContext ctx, Object requestBuilder) {
        Configure conf = Configure.getInstance();
        if (conf.trace_interservice_enabled) {
            try {
                IHttpClient httpclient = this.getProxy();
                if (ctx.gxid == 0L) {
                    ctx.gxid = ctx.txid;
                }
                ctx.lastCalleeId = KeyGen.next();
                httpclient.addHeader(requestBuilder, conf._trace_interservice_gxid_header_key, Hexa32.toString32(ctx.gxid));
                httpclient.addHeader(requestBuilder, conf._trace_interservice_caller_header_key, Hexa32.toString32(ctx.txid));
                httpclient.addHeader(requestBuilder, conf._trace_interservice_callee_header_key, Hexa32.toString32(ctx.lastCalleeId));
                httpclient.addHeader(requestBuilder, conf._trace_interservice_caller_obj_header_key, String.valueOf(conf.getObjHash()));
                if (conf.trace_propagete_b3_header) {
                    httpclient.addHeader(requestBuilder, "x-b3-traceid", Hexa32.toUnsignedLongHex(ctx.gxid));
                    httpclient.addHeader(requestBuilder, "x-b3-parentspanid", Hexa32.toUnsignedLongHex(ctx.txid));
                    httpclient.addHeader(requestBuilder, "x-b3-spanid", Hexa32.toUnsignedLongHex(ctx.lastCalleeId));
                }
                PluginHttpCallTrace.call(ctx, requestBuilder);
            }
            catch (Exception e) {
                Logger.println("A178", e);
                this.ok = false;
            }
        }
    }
}

