/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleLru<K, V> {
    private final Map<K, V> accessCache;
    private final Map<K, V> creationCache;
    final int maxSize;

    public SimpleLru(final int maxSize) {
        this.maxSize = maxSize;
        this.accessCache = new ConcurrentHashMap(maxSize);
        this.creationCache = new LinkedHashMap<K, V>(maxSize, 0.75f){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                if (this.size() > maxSize) {
                    SimpleLru.this.accessCache.remove(eldest.getKey());
                    return true;
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.accessCache.put(key, value);
        Map<K, V> map = this.creationCache;
        synchronized (map) {
            this.creationCache.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        this.accessCache.remove(key);
        Map<K, V> map = this.creationCache;
        synchronized (map) {
            this.creationCache.remove(key);
        }
    }

    public V get(K key) {
        return this.accessCache.get(key);
    }

    public int size() {
        return this.accessCache.size();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.accessCache.entrySet();
    }
}

