/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.ByteArrayEnumer;
import scouter.util.CompareUtil;

public class ByteArrayKeyMap<V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private ByteArrayKeyEntry<V>[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public ByteArrayKeyMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new ByteArrayKeyEntry[initCapacity];
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public ByteArrayKeyMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized ByteArrayEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<ByteArrayKeyEntry<V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(V value) {
        if (value == null) {
            return false;
        }
        ByteArrayKeyEntry<V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            ByteArrayKeyEntry<V> e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(byte[] key) {
        ByteArrayKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private int hash(byte[] h) {
        return Arrays.hashCode(h) & Integer.MAX_VALUE;
    }

    public synchronized V get(byte[] key) {
        ByteArrayKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        ByteArrayKeyEntry<V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        ByteArrayKeyEntry[] newMap = new ByteArrayKeyEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            ByteArrayKeyEntry<V> old = oldMap[i];
            while (old != null) {
                ByteArrayKeyEntry<V> e = old;
                old = old.next;
                int index = this.hash(e.key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized byte[][] keyArray() {
        byte[][] _keys = new byte[this.size()][];
        ByteArrayEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextKey();
        }
        return _keys;
    }

    public synchronized V put(byte[] key, V value) {
        ByteArrayKeyEntry<V>[] tab = this.table;
        int _hash = this.hash(key);
        int index = _hash % tab.length;
        ByteArrayKeyEntry<V> e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = _hash % tab.length;
        }
        tab[index] = e = new ByteArrayKeyEntry<V>(key, value, tab[index]);
        ++this.count;
        return null;
    }

    public synchronized V remove(byte[] key) {
        ByteArrayKeyEntry<V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ByteArrayKeyEntry<V> e = tab[index];
        ByteArrayKeyEntry<V> prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        ByteArrayKeyEntry<V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ByteArrayKeyEntry<V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            ByteArrayKeyEntry<V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Arrays.toString(e.getKey()) + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ByteArrayKeyEntry<V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            ByteArrayKeyEntry<V> e = it.nextElement();
            buf.append("\t").append(Arrays.toString(e.getKey()) + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    public void putAll(ByteArrayKeyMap<V> other) {
        Enumeration<ByteArrayKeyEntry<V>> it = other.entries();
        int max = other.size();
        for (int i = 0; i <= max; ++i) {
            ByteArrayKeyEntry<V> e = it.nextElement();
            this.put(e.getKey(), e.getValue());
        }
    }

    public static class ByteArrayKeyEntry<V> {
        byte[] key;
        V value;
        ByteArrayKeyEntry<V> next;

        protected ByteArrayKeyEntry(byte[] key, V value, ByteArrayKeyEntry<V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new ByteArrayKeyEntry<V>(this.key, this.value, this.next == null ? null : (ByteArrayKeyEntry)this.next.clone());
        }

        public byte[] getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ByteArrayKeyEntry)) {
                return false;
            }
            ByteArrayKeyEntry e = (ByteArrayKeyEntry)o;
            return this.key == e.getKey() && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return Arrays.hashCode(this.key) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return Arrays.toString(this.key) + "=" + this.value.toString();
        }
    }

    private class Enumer
    implements Enumeration,
    ByteArrayEnumer {
        ByteArrayKeyEntry[] table;
        int index;
        ByteArrayKeyEntry entry;
        ByteArrayKeyEntry lastReturned;
        TYPE type;

        Enumer(TYPE type) {
            this.table = ByteArrayKeyMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            return this.entry != null;
        }

        public Object nextElement() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                ByteArrayKeyEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public byte[] nextKey() {
            while (this.entry == null && this.index > 0) {
                this.entry = this.table[--this.index];
            }
            if (this.entry != null) {
                ByteArrayKeyEntry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }
}

