/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;

public class CacheTable<K, V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private ENTRY<K, V>[] table;
    private ENTRY<K, V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private long defaultKeepTime = 0L;
    private int max;

    public CacheTable() {
        this(101, 0.75f);
    }

    public CacheTable(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new ENTRY[initCapacity];
        this.header = new ENTRY<Object, Object>(null, null, 0L, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public synchronized Enumeration<K> keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<ENTRY<K, V>> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    public synchronized V get(K key) {
        ENTRY<K, V> e = this.getEntry(key);
        return e == null ? null : (V)e.getValue();
    }

    public synchronized V getKeepAlive(K key, long keepAlive) {
        ENTRY<K, V> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.keepAlive(keepAlive);
        return e.getValue();
    }

    public synchronized V getKeepAlive(K key) {
        ENTRY<K, V> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.keepAlive(this.defaultKeepTime);
        return e.getValue();
    }

    private ENTRY<K, V> getEntry(K key) {
        if (key == null) {
            return null;
        }
        ENTRY<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ENTRY<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(((ENTRY)e).key, key)) {
                if (e.isExpired()) {
                    this.remove(e.getKey());
                    return null;
                }
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private V getValue(ENTRY<K, V> e) {
        if (e == null) {
            return null;
        }
        if (e.isExpired()) {
            this.remove(((ENTRY)e).key);
            return null;
        }
        return (V)((ENTRY)e).value;
    }

    public synchronized V getFirstValue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getValue(this.header.link_next);
    }

    public synchronized V getLastValue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getValue(this.header.link_prev);
    }

    public synchronized int getRemindTime(K key) {
        ENTRY<K, V> entry = this.getEntry(key);
        if (entry != null) {
            if (((ENTRY)entry).timeOfExpiration == 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)(((ENTRY)entry).timeOfExpiration - System.currentTimeMillis());
        }
        return 0;
    }

    public void clearExpiredItems() {
        try {
            ArrayList<K> delete = new ArrayList<K>();
            Enumeration<ENTRY<K, V>> en = this.entries();
            while (en.hasMoreElements()) {
                ENTRY<K, V> e = en.nextElement();
                if (!e.isExpired()) continue;
                delete.add(e.getKey());
            }
            for (int i = 0; i < delete.size(); ++i) {
                this.remove(delete.get(i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int hash(Object key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        ENTRY<K, V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        ENTRY[] newMap = new ENTRY[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            ENTRY<K, V> old = oldMap[i];
            while (old != null) {
                ENTRY<K, V> e = old;
                old = old.next;
                Object key = ((ENTRY)e).key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public CacheTable<K, V> setMaxRow(int max) {
        this.max = max;
        return this;
    }

    public CacheTable<K, V> setDefaultKeepTime(long time) {
        this.defaultKeepTime = time;
        return this;
    }

    public V put(K key, V value, long keepTime) {
        return this._put(key, value, keepTime, MODE.LAST);
    }

    public V putLast(K key, V value, long keepTime) {
        return this._put(key, value, keepTime, MODE.FORCE_LAST);
    }

    public V putFirst(K key, V value, long keepTime) {
        return this._put(key, value, keepTime, MODE.FORCE_FIRST);
    }

    public V put(K key, V value) {
        return this._put(key, value, this.defaultKeepTime, MODE.LAST);
    }

    public V putLast(K key, V value) {
        return this._put(key, value, this.defaultKeepTime, MODE.FORCE_LAST);
    }

    public V putFirst(K key, V value) {
        return this._put(key, value, this.defaultKeepTime, MODE.FORCE_FIRST);
    }

    private synchronized V _put(K key, V value, long keepTime, MODE m) {
        ENTRY<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ENTRY<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(((ENTRY)e).key, key)) {
                Object old = ((ENTRY)e).value;
                ((ENTRY)e).value = value;
                e.keepAlive(keepTime);
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return (V)old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        this.removeLast();
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        this.removeFirst();
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        e = new ENTRY<K, V>(key, value, keepTime, tab[index]);
        tab[index] = e;
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    public synchronized V remove(Object key) {
        if (key == null) {
            return null;
        }
        ENTRY<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        ENTRY<K, V> e = tab[index];
        ENTRY<K, V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(((ENTRY)e).key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = ((ENTRY)e).value;
                ((ENTRY)e).value = null;
                this.unchain(e);
                return (V)oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized V removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized V removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        ENTRY<K, V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ENTRY<K, V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            ENTRY<K, V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toKeyString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<K> it = this.keys();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            K key = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(key);
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<ENTRY<K, V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            ENTRY<K, V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(ENTRY link_prev, ENTRY link_next, ENTRY e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(ENTRY e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) throws Exception {
        CacheTable<Integer, Integer> t = new CacheTable().setDefaultKeepTime(1000L).setMaxRow(100);
        for (int i = 0; i < 100; ++i) {
            t.put(i, i);
        }
        Enumeration e = t.keys();
        System.out.println(t.get(0));
        System.out.println(t.get(10));
        System.out.println(t.get(99));
        Thread.sleep(2000L);
        System.out.println("----->" + t.size());
        System.out.println(t.getFirstValue());
    }

    private class Enumer<V>
    implements Enumeration {
        TYPE type;
        ENTRY entry;
        ENTRY lastEnt;

        Enumer(TYPE type) {
            this.entry = ((CacheTable)CacheTable.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return CacheTable.this.header != this.entry && this.entry != null;
        }

        public V nextElement() {
            if (this.hasMoreElements()) {
                ENTRY e = this.lastEnt = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return (V)e.key;
                    }
                    case VALUES: {
                        return (V)e.value;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    public static class ENTRY<K, V> {
        private K key;
        private V value;
        private long timeOfExpiration;
        private long keepTime = 0L;
        ENTRY<K, V> next;
        ENTRY<K, V> link_next;
        ENTRY<K, V> link_prev;

        protected ENTRY(K key, V value, long keepTime, ENTRY next) {
            this.key = key;
            this.value = value;
            this.keepAlive(keepTime);
            this.next = next;
        }

        protected Object clone() {
            return new ENTRY<K, V>(this.key, this.value, this.keepTime, this.next == null ? null : (ENTRY)this.next.clone());
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean isExpired() {
            if (this.timeOfExpiration > 0L) {
                return this.timeOfExpiration < System.currentTimeMillis();
            }
            return false;
        }

        public void keepAlive(long keepTime) {
            if (keepTime > 0L) {
                this.keepTime = keepTime;
                this.timeOfExpiration = System.currentTimeMillis() + keepTime;
            } else {
                this.keepTime = 0L;
                this.timeOfExpiration = 0L;
            }
        }

        public void keep() {
            if (this.keepTime > 0L) {
                this.timeOfExpiration = System.currentTimeMillis() + this.keepTime;
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof ENTRY)) {
                return false;
            }
            ENTRY e = (ENTRY)o;
            return CompareUtil.equals(this.key, e.key) && CompareUtil.equals(this.value, e.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

