/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataUtil {
    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void readFully(InputStream in, byte[] buff) throws IOException {
        DataUtil.readFully(in, buff, 0, buff.length);
    }

    public static void readFully(InputStream in, byte[] buff, int offset, int length) throws IOException {
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < length; n += count) {
            count = in.read(buff, offset + n, length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static int readUnsignedByte(InputStream in) throws IOException {
        int ch = in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public static int readUnsignedShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public static long readLong(InputStream in) throws IOException {
        byte[] buffer = new byte[8];
        DataUtil.readFully(in, buffer, 0, 8);
        return ((long)buffer[0] << 56) + ((long)(buffer[1] & 0xFF) << 48) + ((long)(buffer[2] & 0xFF) << 40) + ((long)(buffer[3] & 0xFF) << 32) + ((long)(buffer[4] & 0xFF) << 24) + (long)((buffer[5] & 0xFF) << 16) + (long)((buffer[6] & 0xFF) << 8) + (long)((buffer[7] & 0xFF) << 0);
    }

    public static byte[] readBlob(InputStream in) throws IOException {
        int baselen = DataUtil.readUnsignedByte(in);
        switch (baselen) {
            case 255: {
                int len = DataUtil.readUnsignedShort(in);
                byte[] buffer = DataUtil.read(in, len);
                return buffer;
            }
            case 254: {
                int len = DataUtil.readInt(in);
                byte[] buffer = DataUtil.read(in, len);
                return buffer;
            }
            case 0: {
                return new byte[0];
            }
        }
        byte[] buffer = DataUtil.read(in, baselen);
        return buffer;
    }

    public static byte[] read(InputStream in, int len) throws IOException {
        byte[] buff = new byte[len];
        DataUtil.readFully(in, buff);
        return buff;
    }

    public static String readText(InputStream in) throws IOException {
        byte[] buffer = DataUtil.readBlob(in);
        return new String(buffer, "UTF8");
    }
}

