/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipFileUtil {
    private static final int FILE_BUFFER_SIZE = 8096;

    public static void sendZipFile(ZipOutputStream zos, File file) throws Exception {
        String zipFilename = file.getAbsolutePath();
        int index = zipFilename.lastIndexOf(File.separator);
        if (index >= 0) {
            zipFilename = zipFilename.substring(index + 1);
        }
        ZipEntry zipEntry = new ZipEntry(zipFilename);
        zipEntry.setMethod(8);
        zipEntry.setSize(file.length());
        zos.putNextEntry(zipEntry);
        int readSize = 0;
        byte[] buffer = new byte[8096];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        while (0 != (readSize = bis.read(buffer)) && -1 != readSize) {
            zos.write(buffer, 0, readSize);
        }
        bis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recieveZipFile(ZipInputStream zis, String relativePath) throws Exception {
        ZipEntry zipEntry = null;
        byte[] buffer = new byte[8096];
        while (null != (zipEntry = zis.getNextEntry())) {
            File outFile = new File(relativePath + "/" + zipEntry.getName());
            File parentFolder = outFile.getParentFile();
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            FilterOutputStream fos = null;
            try {
                int readSize;
                fos = new BufferedOutputStream(new FileOutputStream(outFile));
                while ((readSize = zis.read(buffer)) > 0) {
                    ((BufferedOutputStream)fos).write(buffer, 0, readSize);
                }
                ((BufferedOutputStream)fos).flush();
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static int caculReadSize(int remainLength) {
        if (remainLength >= 8096) {
            return 8096;
        }
        return remainLength;
    }
}

