/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.counters;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import scouter.lang.Counter;
import scouter.lang.Family;
import scouter.lang.ObjectType;
import scouter.util.FileUtil;
import scouter.util.StringKeyLinkedMap;

public class CounterEngine {
    public static final String TAG_COUNTERS = "Counters";
    public static final String TAG_FAMILYS = "Familys";
    public static final String TAG_TYPES = "Types";
    public static final String TAG_FAMILY = "Family";
    public static final String TAG_COUNTER = "Counter";
    public static final String TAG_OBJECT_TYPE = "ObjectType";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_MASTER = "master";
    public static final String ATTR_DISPLAY = "disp";
    public static final String ATTR_UNIT = "unit";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_FAMILY = "family";
    public static final String ATTR_ALL = "all";
    public static final String ATTR_TOTAL = "total";
    public static final String ATTR_SUBOBJECT = "sub-object";
    private StringKeyLinkedMap<Family> familyMap = new StringKeyLinkedMap();
    private StringKeyLinkedMap<ObjectType> objTypeMap = new StringKeyLinkedMap();

    public void parse(byte[] content) {
        try {
            String value;
            String name;
            Attr attr;
            Node counterAttr;
            int k;
            Counter counter;
            Element counterElement;
            NamedNodeMap counterAttrMap;
            Node counterNode;
            int j;
            NodeList counterNodes;
            String value2;
            String name2;
            Attr attr2;
            NamedNodeMap nodeMap;
            Node node;
            int i;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new ByteArrayInputStream(content)));
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName(TAG_FAMILY);
            for (i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
                Element familyElement;
                node = nodeList.item(i);
                if (node.getNodeType() != 1 || (nodeMap = (familyElement = (Element)node).getAttributes()) == null) continue;
                Family family = new Family();
                for (int j2 = 0; j2 < nodeMap.getLength(); ++j2) {
                    Node familyAttr = nodeMap.item(j2);
                    if (familyAttr.getNodeType() != 2) continue;
                    attr2 = (Attr)familyAttr;
                    name2 = attr2.getName();
                    value2 = attr2.getValue();
                    if (ATTR_NAME.equals(name2)) {
                        family.setName(value2);
                        continue;
                    }
                    if (ATTR_MASTER.equals(name2)) {
                        family.setMaster(value2);
                        continue;
                    }
                    family.setAttribute(name2, value2);
                }
                if (family.getName() != null) {
                    this.familyMap.put(family.getName(), family);
                }
                counterNodes = familyElement.getElementsByTagName(TAG_COUNTER);
                for (j = 0; counterNodes != null && j < counterNodes.getLength(); ++j) {
                    counterNode = counterNodes.item(j);
                    if (counterNode.getNodeType() != 1 || (counterAttrMap = (counterElement = (Element)counterNode).getAttributes()) == null) continue;
                    counter = new Counter();
                    for (k = 0; k < counterAttrMap.getLength(); ++k) {
                        counterAttr = counterAttrMap.item(k);
                        if (counterAttr.getNodeType() != 2) continue;
                        attr = (Attr)counterAttr;
                        name = attr.getName();
                        value = attr.getValue();
                        if (ATTR_NAME.equals(name)) {
                            counter.setName(value);
                            continue;
                        }
                        if (ATTR_DISPLAY.equals(name)) {
                            counter.setDisplayName(value);
                            continue;
                        }
                        if (ATTR_UNIT.equals(name)) {
                            counter.setUnit(value);
                            continue;
                        }
                        if (ATTR_ICON.equals(name)) {
                            counter.setIcon(value);
                            continue;
                        }
                        if (ATTR_ALL.equals(name)) {
                            counter.setAll(Boolean.valueOf(value));
                            continue;
                        }
                        if (ATTR_TOTAL.equals(name)) {
                            counter.setTotal(Boolean.valueOf(value));
                            continue;
                        }
                        counter.setAttribute(name, value);
                    }
                    if (counter.getName() == null) continue;
                    family.addCounter(counter);
                }
            }
            nodeList = doc.getElementsByTagName(TAG_OBJECT_TYPE);
            for (i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
                Element objElement;
                node = nodeList.item(i);
                if (node.getNodeType() != 1 || (nodeMap = (objElement = (Element)node).getAttributes()) == null) continue;
                ObjectType objType = new ObjectType();
                for (int j3 = 0; j3 < nodeMap.getLength(); ++j3) {
                    Node objAttr = nodeMap.item(j3);
                    if (objAttr.getNodeType() != 2) continue;
                    attr2 = (Attr)objAttr;
                    name2 = attr2.getName();
                    value2 = attr2.getValue();
                    if (ATTR_NAME.equals(name2)) {
                        objType.setName(value2);
                        continue;
                    }
                    if (ATTR_DISPLAY.equals(name2)) {
                        objType.setDisplayName(value2);
                        continue;
                    }
                    if (ATTR_FAMILY.equals(name2)) {
                        objType.setFamily(this.familyMap.get(value2));
                        continue;
                    }
                    if (ATTR_ICON.equals(name2)) {
                        objType.setIcon(value2);
                        continue;
                    }
                    if (ATTR_SUBOBJECT.equals(name2)) {
                        objType.setSubObject(Boolean.valueOf(value2));
                        continue;
                    }
                    objType.setAttribute(name2, value2);
                }
                if (objType.getName() != null) {
                    ObjectType existType = this.objTypeMap.get(objType.getName());
                    if (existType == null) {
                        this.objTypeMap.put(objType.getName(), objType);
                    } else {
                        objType = existType;
                    }
                }
                counterNodes = objElement.getElementsByTagName(TAG_COUNTER);
                for (j = 0; counterNodes != null && j < counterNodes.getLength(); ++j) {
                    counterNode = counterNodes.item(j);
                    if (counterNode.getNodeType() != 1 || (counterAttrMap = (counterElement = (Element)counterNode).getAttributes()) == null) continue;
                    counter = new Counter();
                    for (k = 0; k < counterAttrMap.getLength(); ++k) {
                        counterAttr = counterAttrMap.item(k);
                        if (counterAttr.getNodeType() != 2) continue;
                        attr = (Attr)counterAttr;
                        name = attr.getName();
                        value = attr.getValue();
                        if (ATTR_NAME.equals(name)) {
                            counter.setName(value);
                            continue;
                        }
                        if (ATTR_DISPLAY.equals(name)) {
                            counter.setDisplayName(value);
                            continue;
                        }
                        if (ATTR_UNIT.equals(name)) {
                            counter.setUnit(value);
                            continue;
                        }
                        if (ATTR_ICON.equals(name)) {
                            counter.setIcon(value);
                            continue;
                        }
                        if (ATTR_ALL.equals(name)) {
                            counter.setAll(Boolean.valueOf(value));
                            continue;
                        }
                        if (ATTR_TOTAL.equals(name)) {
                            counter.setTotal(Boolean.valueOf(value));
                            continue;
                        }
                        counter.setAttribute(name, value);
                    }
                    if (counter.getName() == null) continue;
                    objType.addCounter(counter);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void clear() {
        this.familyMap.clear();
        this.objTypeMap.clear();
    }

    public String[] getChildren(String family) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<ObjectType> types = this.objTypeMap.values();
        while (types.hasMoreElements()) {
            ObjectType obj = types.nextElement();
            if (!family.equals(obj.getFamily().getName())) continue;
            list.add(obj.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public ArrayList<String> getObjTypeListWithDisplay(String attr) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<ObjectType> types = this.objTypeMap.values();
        while (types.hasMoreElements()) {
            ObjectType obj = types.nextElement();
            Family family = obj.getFamily();
            if (!family.isTrueAttribute(attr)) continue;
            list.add(obj.getDisplayName() + ":" + obj.getName());
        }
        return list;
    }

    public ArrayList<String> getAllObjectType() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<ObjectType> types = this.objTypeMap.values();
        while (types.hasMoreElements()) {
            ObjectType obj = types.nextElement();
            list.add(obj.getName());
        }
        Collections.sort(list);
        return list;
    }

    public String getDisplayNameObjectType(String objType) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return "<unknown>";
        }
        return obj.getDisplayName();
    }

    public ArrayList<String> getAllCounterList() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<ObjectType> types = this.objTypeMap.values();
        while (types.hasMoreElements()) {
            ObjectType obj = types.nextElement();
            Counter[] counters = obj.listCounters();
            if (counters == null || counters.length == 0) continue;
            for (Counter counter : counters) {
                if (!counter.isAll()) continue;
                list.add(obj.getName() + ":" + counter.getDisplayName() + ":" + counter.getName());
            }
        }
        return list;
    }

    public ArrayList<String> getAllCounterList(String objType) {
        Counter[] counters;
        ArrayList<String> list = new ArrayList<String>();
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return list;
        }
        for (Counter counter : counters = obj.listCounters()) {
            if (!counter.isAll()) continue;
            list.add(counter.getName());
        }
        return list;
    }

    public ArrayList<String> getTotalCounterList() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<ObjectType> types = this.objTypeMap.values();
        while (types.hasMoreElements()) {
            Counter[] counters;
            ObjectType obj = types.nextElement();
            for (Counter counter : counters = obj.listCounters()) {
                if (!counter.isTotal()) continue;
                list.add(obj.getName() + ":" + counter.getDisplayName() + ":" + counter.getName());
            }
        }
        return list;
    }

    public ArrayList<String> getTotalCounterList(String objType) {
        Counter[] counters;
        ArrayList<String> list = new ArrayList<String>();
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return list;
        }
        for (Counter counter : counters = obj.listCounters()) {
            if (!counter.isTotal()) continue;
            list.add(counter.getName());
        }
        return list;
    }

    public String getCounterDisplayName(String objType, String counter) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return "";
        }
        Counter c = obj.getCounter(counter);
        if (c == null) {
            return "";
        }
        return c.getDisplayName();
    }

    public String getMasterCounterUnit(String objType) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return "";
        }
        String master = obj.getFamily().getMaster();
        Counter counter = obj.getCounter(master);
        if (counter == null) {
            return "";
        }
        return counter.getUnit();
    }

    public String getMasterCounter(String objType) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return null;
        }
        return obj.getFamily().getMaster();
    }

    public String[] getSortedCounterName(String objType) {
        Counter[] counters;
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Counter counter : counters = obj.listCounters()) {
            list.add(counter.getName());
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public String[] getSortedCounterDisplayName(String objType) {
        Counter[] counters;
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Counter counter : counters = obj.listCounters()) {
            list.add(counter.getDisplayName());
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public ArrayList<String> getAllCounterWithDisplay(String objType) {
        Counter[] counters;
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Counter counter : counters = obj.listCounters()) {
            if (!counter.isAll()) continue;
            list.add(counter.getDisplayName() + ":" + counter.getName());
        }
        Collections.sort(list);
        return list;
    }

    public boolean isChildOf(String objType, String familyName) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return false;
        }
        return familyName.equalsIgnoreCase(obj.getFamily().getName());
    }

    public boolean isCounterOf(String counter, String objType) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return false;
        }
        return obj.getCounter(counter) != null;
    }

    public Set<String> getCounterSet(String objType) {
        Counter[] counters;
        HashSet<String> set = new HashSet<String>();
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return set;
        }
        for (Counter counter : counters = obj.listCounters()) {
            set.add(counter.getName());
        }
        return set;
    }

    public Set<Counter> getCounterObjectSet(String objType) {
        Counter[] counters;
        HashSet<Counter> set = new HashSet<Counter>();
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return set;
        }
        for (Counter counter : counters = obj.listCounters()) {
            set.add(counter);
        }
        return set;
    }

    public String getCounterIconFileName(String objType, String counter) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return null;
        }
        Counter c = obj.getCounter(counter);
        if (c == null) {
            return "";
        }
        return c.getIcon();
    }

    public String getCounterUnit(String objType, String counter) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return null;
        }
        Counter c = obj.getCounter(counter);
        if (c == null) {
            return "";
        }
        return c.getUnit();
    }

    public boolean isTrueAction(String objType, String actionName) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return false;
        }
        return obj.getFamily().isTrueAttribute(actionName);
    }

    public Family getFamily(String familyName) {
        return this.familyMap.get(familyName);
    }

    public ObjectType getObjectType(String objType) {
        return this.objTypeMap.get(objType);
    }

    public String getFamilyNameFromObjType(String objType) {
        return this.objTypeMap.get(objType).getFamily().getName();
    }

    public boolean isUnknownObjectType(String objType) {
        ObjectType obj = this.objTypeMap.get(objType);
        return obj == null;
    }

    public boolean isPrimaryObject(String objType) {
        ObjectType obj = this.objTypeMap.get(objType);
        if (obj == null) {
            return false;
        }
        return !obj.isSubObject();
    }

    public ObjectType addObjectType(ObjectType objType) {
        return this.objTypeMap.put(objType.getName(), objType);
    }

    public Family addFamily(Family family) {
        return this.familyMap.put(family.getName(), family);
    }

    public String[] getFamilyNames() {
        return this.familyMap.keyArray();
    }

    public StringKeyLinkedMap<ObjectType> getRawObjectTypeMap() {
        return this.objTypeMap;
    }

    public StringKeyLinkedMap<Family> getRawFamilyMap() {
        return this.familyMap;
    }

    public static void main(String[] args) {
        File f = new File("/Users/gunlee/Documents/workspace/scouter/scouter/scouter.common/src/main/resources/scouter/lang/counters/counters.xml");
        System.out.println(f.canRead());
        byte[] content = FileUtil.readAll(f);
        CounterEngine ce = new CounterEngine();
        ce.parse(content);
        System.out.println(ce.getAllObjectType());
        System.out.println(ce.getDisplayNameObjectType("tomcat"));
        System.out.println(ce.getAllCounterList());
        System.out.println(ce.getTotalCounterList());
        System.out.println(ce.getCounterDisplayName("tomcat", "visit0"));
        System.out.println(Arrays.toString(ce.getSortedCounterName("tomcat")));
        System.out.println(Arrays.toString(ce.getSortedCounterDisplayName("tomcat")));
        System.out.println(ce.getCounterIconFileName("tomcat", "visit0"));
        System.out.println(ce.getCounterUnit("tomcat", "visit0"));
    }
}

