/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class XLogProfilePack2
extends XLogProfilePack
implements Pack {
    private boolean _forDrop;
    private boolean _forProcessDelayingChildren;
    public long gxid;
    public byte xType;
    public byte discardType;
    public boolean ignoreGlobalConsequentSampling;

    @Override
    public byte getPackType() {
        return 27;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Profile2 ");
        sb.append(DateUtil.timestamp(this.time));
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" txid=").append(Hexa32.toString32(this.txid));
        sb.append(" gxid=").append(Hexa32.toString32(this.gxid));
        sb.append(" profile=").append(this.profile == null ? null : Integer.valueOf(this.profile.length));
        return sb.toString();
    }

    public boolean isDriving() {
        return this.gxid == this.txid || this.gxid == 0L;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        super.write(dout);
        dout.writeLong(this.gxid);
        dout.writeByte(this.xType);
        dout.writeByte(this.discardType);
        dout.writeBoolean(this.ignoreGlobalConsequentSampling);
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        super.read(din);
        this.gxid = din.readLong();
        this.xType = din.readByte();
        this.discardType = din.readByte();
        this.ignoreGlobalConsequentSampling = din.readBoolean();
        return this;
    }

    public static XLogProfilePack2 forInternalDropProcessing(XLogPack xLogPack) {
        XLogProfilePack2 pack = new XLogProfilePack2();
        pack.gxid = xLogPack.gxid;
        pack.txid = xLogPack.txid;
        pack._forDrop = true;
        return pack;
    }

    public static XLogProfilePack2 forInternalDelayingChildrenProcessing(XLogPack xLogPack) {
        XLogProfilePack2 pack = new XLogProfilePack2();
        pack.gxid = xLogPack.gxid;
        pack.txid = xLogPack.txid;
        pack._forProcessDelayingChildren = true;
        return pack;
    }

    public boolean isForDrop() {
        return this._forDrop;
    }

    public boolean isForProcessDelayingChildren() {
        return this._forProcessDelayingChildren;
    }
}

