/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Event {
    private final String eventId;
    private final Optional<String> deviceId;
    private final String eventType;
    private final String workspaceId;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime occurredAt;

    private Event(String eventId, Optional<String> deviceId, String eventType, String workspaceId, OffsetDateTime createdAt, OffsetDateTime occurredAt) {
        this.eventId = eventId;
        this.deviceId = deviceId;
        this.eventType = eventType;
        this.workspaceId = workspaceId;
        this.createdAt = createdAt;
        this.occurredAt = occurredAt;
    }

    @JsonProperty(value="event_id")
    public String getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="device_id")
    public Optional<String> getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="event_type")
    public String getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="occurred_at")
    public OffsetDateTime getOccurredAt() {
        return this.occurredAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Event && this.equalTo((Event)other);
    }

    private boolean equalTo(Event other) {
        return this.eventId.equals(other.eventId) && this.deviceId.equals(other.deviceId) && this.eventType.equals(other.eventType) && this.workspaceId.equals(other.workspaceId) && this.createdAt.equals(other.createdAt) && this.occurredAt.equals(other.occurredAt);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.deviceId, this.eventType, this.workspaceId, this.createdAt, this.occurredAt);
    }

    public String toString() {
        return "Event{eventId: " + this.eventId + ", deviceId: " + this.deviceId + ", eventType: " + this.eventType + ", workspaceId: " + this.workspaceId + ", createdAt: " + this.createdAt + ", occurredAt: " + this.occurredAt + "}";
    }

    public static EventIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EventIdStage,
    EventTypeStage,
    WorkspaceIdStage,
    CreatedAtStage,
    OccurredAtStage,
    _FinalStage {
        private String eventId;
        private String eventType;
        private String workspaceId;
        private OffsetDateTime createdAt;
        private OffsetDateTime occurredAt;
        private Optional<String> deviceId = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Event other) {
            this.eventId(other.getEventId());
            this.deviceId(other.getDeviceId());
            this.eventType(other.getEventType());
            this.workspaceId(other.getWorkspaceId());
            this.createdAt(other.getCreatedAt());
            this.occurredAt(other.getOccurredAt());
            return this;
        }

        @Override
        @JsonSetter(value="event_id")
        public EventTypeStage eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Override
        @JsonSetter(value="event_type")
        public WorkspaceIdStage eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public CreatedAtStage workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public OccurredAtStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="occurred_at")
        public _FinalStage occurredAt(OffsetDateTime occurredAt) {
            this.occurredAt = occurredAt;
            return this;
        }

        @Override
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = Optional.of(deviceId);
            return this;
        }

        @Override
        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public _FinalStage deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public Event build() {
            return new Event(this.eventId, this.deviceId, this.eventType, this.workspaceId, this.createdAt, this.occurredAt);
        }
    }

    public static interface _FinalStage {
        public Event build();

        public _FinalStage deviceId(Optional<String> var1);

        public _FinalStage deviceId(String var1);
    }

    public static interface OccurredAtStage {
        public _FinalStage occurredAt(OffsetDateTime var1);
    }

    public static interface CreatedAtStage {
        public OccurredAtStage createdAt(OffsetDateTime var1);
    }

    public static interface WorkspaceIdStage {
        public CreatedAtStage workspaceId(String var1);
    }

    public static interface EventTypeStage {
        public WorkspaceIdStage eventType(String var1);
    }

    public static interface EventIdStage {
        public EventTypeStage eventId(String var1);

        public Builder from(Event var1);
    }
}

