/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.connectwebviews.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.AcceptedProvider;
import com.seam.api.types.CustomMetadataValue;
import com.seam.api.types.ProviderCategory;
import com.seam.api.types.SelectionMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ConnectWebviewsCreateRequest {
    private final Optional<SelectionMode> deviceSelectionMode;
    private final Optional<String> customRedirectUrl;
    private final Optional<String> customRedirectFailureUrl;
    private final Optional<List<AcceptedProvider>> acceptedProviders;
    private final Optional<ProviderCategory> providerCategory;
    private final Optional<Map<String, CustomMetadataValue>> customMetadata;
    private final Optional<Boolean> automaticallyManageNewDevices;
    private final Optional<Boolean> waitForDeviceCreation;
    private final Map<String, Object> additionalProperties;

    private ConnectWebviewsCreateRequest(Optional<SelectionMode> deviceSelectionMode, Optional<String> customRedirectUrl, Optional<String> customRedirectFailureUrl, Optional<List<AcceptedProvider>> acceptedProviders, Optional<ProviderCategory> providerCategory, Optional<Map<String, CustomMetadataValue>> customMetadata, Optional<Boolean> automaticallyManageNewDevices, Optional<Boolean> waitForDeviceCreation, Map<String, Object> additionalProperties) {
        this.deviceSelectionMode = deviceSelectionMode;
        this.customRedirectUrl = customRedirectUrl;
        this.customRedirectFailureUrl = customRedirectFailureUrl;
        this.acceptedProviders = acceptedProviders;
        this.providerCategory = providerCategory;
        this.customMetadata = customMetadata;
        this.automaticallyManageNewDevices = automaticallyManageNewDevices;
        this.waitForDeviceCreation = waitForDeviceCreation;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="device_selection_mode")
    public Optional<SelectionMode> getDeviceSelectionMode() {
        return this.deviceSelectionMode;
    }

    @JsonProperty(value="custom_redirect_url")
    public Optional<String> getCustomRedirectUrl() {
        return this.customRedirectUrl;
    }

    @JsonProperty(value="custom_redirect_failure_url")
    public Optional<String> getCustomRedirectFailureUrl() {
        return this.customRedirectFailureUrl;
    }

    @JsonProperty(value="accepted_providers")
    public Optional<List<AcceptedProvider>> getAcceptedProviders() {
        return this.acceptedProviders;
    }

    @JsonProperty(value="provider_category")
    public Optional<ProviderCategory> getProviderCategory() {
        return this.providerCategory;
    }

    @JsonProperty(value="custom_metadata")
    public Optional<Map<String, CustomMetadataValue>> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="automatically_manage_new_devices")
    public Optional<Boolean> getAutomaticallyManageNewDevices() {
        return this.automaticallyManageNewDevices;
    }

    @JsonProperty(value="wait_for_device_creation")
    public Optional<Boolean> getWaitForDeviceCreation() {
        return this.waitForDeviceCreation;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConnectWebviewsCreateRequest && this.equalTo((ConnectWebviewsCreateRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConnectWebviewsCreateRequest other) {
        return this.deviceSelectionMode.equals(other.deviceSelectionMode) && this.customRedirectUrl.equals(other.customRedirectUrl) && this.customRedirectFailureUrl.equals(other.customRedirectFailureUrl) && this.acceptedProviders.equals(other.acceptedProviders) && this.providerCategory.equals(other.providerCategory) && this.customMetadata.equals(other.customMetadata) && this.automaticallyManageNewDevices.equals(other.automaticallyManageNewDevices) && this.waitForDeviceCreation.equals(other.waitForDeviceCreation);
    }

    public int hashCode() {
        return Objects.hash(this.deviceSelectionMode, this.customRedirectUrl, this.customRedirectFailureUrl, this.acceptedProviders, this.providerCategory, this.customMetadata, this.automaticallyManageNewDevices, this.waitForDeviceCreation);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<SelectionMode> deviceSelectionMode = Optional.empty();
        private Optional<String> customRedirectUrl = Optional.empty();
        private Optional<String> customRedirectFailureUrl = Optional.empty();
        private Optional<List<AcceptedProvider>> acceptedProviders = Optional.empty();
        private Optional<ProviderCategory> providerCategory = Optional.empty();
        private Optional<Map<String, CustomMetadataValue>> customMetadata = Optional.empty();
        private Optional<Boolean> automaticallyManageNewDevices = Optional.empty();
        private Optional<Boolean> waitForDeviceCreation = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConnectWebviewsCreateRequest other) {
            this.deviceSelectionMode(other.getDeviceSelectionMode());
            this.customRedirectUrl(other.getCustomRedirectUrl());
            this.customRedirectFailureUrl(other.getCustomRedirectFailureUrl());
            this.acceptedProviders(other.getAcceptedProviders());
            this.providerCategory(other.getProviderCategory());
            this.customMetadata(other.getCustomMetadata());
            this.automaticallyManageNewDevices(other.getAutomaticallyManageNewDevices());
            this.waitForDeviceCreation(other.getWaitForDeviceCreation());
            return this;
        }

        @JsonSetter(value="device_selection_mode", nulls=Nulls.SKIP)
        public Builder deviceSelectionMode(Optional<SelectionMode> deviceSelectionMode) {
            this.deviceSelectionMode = deviceSelectionMode;
            return this;
        }

        public Builder deviceSelectionMode(SelectionMode deviceSelectionMode) {
            this.deviceSelectionMode = Optional.of(deviceSelectionMode);
            return this;
        }

        @JsonSetter(value="custom_redirect_url", nulls=Nulls.SKIP)
        public Builder customRedirectUrl(Optional<String> customRedirectUrl) {
            this.customRedirectUrl = customRedirectUrl;
            return this;
        }

        public Builder customRedirectUrl(String customRedirectUrl) {
            this.customRedirectUrl = Optional.of(customRedirectUrl);
            return this;
        }

        @JsonSetter(value="custom_redirect_failure_url", nulls=Nulls.SKIP)
        public Builder customRedirectFailureUrl(Optional<String> customRedirectFailureUrl) {
            this.customRedirectFailureUrl = customRedirectFailureUrl;
            return this;
        }

        public Builder customRedirectFailureUrl(String customRedirectFailureUrl) {
            this.customRedirectFailureUrl = Optional.of(customRedirectFailureUrl);
            return this;
        }

        @JsonSetter(value="accepted_providers", nulls=Nulls.SKIP)
        public Builder acceptedProviders(Optional<List<AcceptedProvider>> acceptedProviders) {
            this.acceptedProviders = acceptedProviders;
            return this;
        }

        public Builder acceptedProviders(List<AcceptedProvider> acceptedProviders) {
            this.acceptedProviders = Optional.of(acceptedProviders);
            return this;
        }

        @JsonSetter(value="provider_category", nulls=Nulls.SKIP)
        public Builder providerCategory(Optional<ProviderCategory> providerCategory) {
            this.providerCategory = providerCategory;
            return this;
        }

        public Builder providerCategory(ProviderCategory providerCategory) {
            this.providerCategory = Optional.of(providerCategory);
            return this;
        }

        @JsonSetter(value="custom_metadata", nulls=Nulls.SKIP)
        public Builder customMetadata(Optional<Map<String, CustomMetadataValue>> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Builder customMetadata(Map<String, CustomMetadataValue> customMetadata) {
            this.customMetadata = Optional.of(customMetadata);
            return this;
        }

        @JsonSetter(value="automatically_manage_new_devices", nulls=Nulls.SKIP)
        public Builder automaticallyManageNewDevices(Optional<Boolean> automaticallyManageNewDevices) {
            this.automaticallyManageNewDevices = automaticallyManageNewDevices;
            return this;
        }

        public Builder automaticallyManageNewDevices(Boolean automaticallyManageNewDevices) {
            this.automaticallyManageNewDevices = Optional.of(automaticallyManageNewDevices);
            return this;
        }

        @JsonSetter(value="wait_for_device_creation", nulls=Nulls.SKIP)
        public Builder waitForDeviceCreation(Optional<Boolean> waitForDeviceCreation) {
            this.waitForDeviceCreation = waitForDeviceCreation;
            return this;
        }

        public Builder waitForDeviceCreation(Boolean waitForDeviceCreation) {
            this.waitForDeviceCreation = Optional.of(waitForDeviceCreation);
            return this;
        }

        public ConnectWebviewsCreateRequest build() {
            return new ConnectWebviewsCreateRequest(this.deviceSelectionMode, this.customRedirectUrl, this.customRedirectFailureUrl, this.acceptedProviders, this.providerCategory, this.customMetadata, this.automaticallyManageNewDevices, this.waitForDeviceCreation, this.additionalProperties);
        }
    }
}

