/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.DeviceCapabilitiesSupportedItem;
import com.seam.api.types.DeviceErrorsItem;
import com.seam.api.types.DeviceProperties;
import com.seam.api.types.DeviceType;
import com.seam.api.types.DeviceWarningsItem;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Device {
    private final String deviceId;
    private final DeviceType deviceType;
    private final List<DeviceCapabilitiesSupportedItem> capabilitiesSupported;
    private final DeviceProperties properties;
    private final Optional<Object> location;
    private final String connectedAccountId;
    private final String workspaceId;
    private final List<DeviceErrorsItem> errors;
    private final List<DeviceWarningsItem> warnings;
    private final OffsetDateTime createdAt;
    private final boolean isManaged;
    private final Map<String, Object> additionalProperties;

    private Device(String deviceId, DeviceType deviceType, List<DeviceCapabilitiesSupportedItem> capabilitiesSupported, DeviceProperties properties, Optional<Object> location, String connectedAccountId, String workspaceId, List<DeviceErrorsItem> errors, List<DeviceWarningsItem> warnings, OffsetDateTime createdAt, boolean isManaged, Map<String, Object> additionalProperties) {
        this.deviceId = deviceId;
        this.deviceType = deviceType;
        this.capabilitiesSupported = capabilitiesSupported;
        this.properties = properties;
        this.location = location;
        this.connectedAccountId = connectedAccountId;
        this.workspaceId = workspaceId;
        this.errors = errors;
        this.warnings = warnings;
        this.createdAt = createdAt;
        this.isManaged = isManaged;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="device_type")
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @JsonProperty(value="capabilities_supported")
    public List<DeviceCapabilitiesSupportedItem> getCapabilitiesSupported() {
        return this.capabilitiesSupported;
    }

    @JsonProperty(value="properties")
    public DeviceProperties getProperties() {
        return this.properties;
    }

    @JsonProperty(value="location")
    public Optional<Object> getLocation() {
        return this.location;
    }

    @JsonProperty(value="connected_account_id")
    public String getConnectedAccountId() {
        return this.connectedAccountId;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="errors")
    public List<DeviceErrorsItem> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="warnings")
    public List<DeviceWarningsItem> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="is_managed")
    public boolean getIsManaged() {
        return this.isManaged;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Device && this.equalTo((Device)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Device other) {
        return this.deviceId.equals(other.deviceId) && this.deviceType.equals((Object)other.deviceType) && this.capabilitiesSupported.equals(other.capabilitiesSupported) && this.properties.equals(other.properties) && this.location.equals(other.location) && this.connectedAccountId.equals(other.connectedAccountId) && this.workspaceId.equals(other.workspaceId) && this.errors.equals(other.errors) && this.warnings.equals(other.warnings) && this.createdAt.equals(other.createdAt) && this.isManaged == other.isManaged;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.deviceType, this.capabilitiesSupported, this.properties, this.location, this.connectedAccountId, this.workspaceId, this.errors, this.warnings, this.createdAt, this.isManaged});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    DeviceTypeStage,
    PropertiesStage,
    ConnectedAccountIdStage,
    WorkspaceIdStage,
    CreatedAtStage,
    IsManagedStage,
    _FinalStage {
        private String deviceId;
        private DeviceType deviceType;
        private DeviceProperties properties;
        private String connectedAccountId;
        private String workspaceId;
        private OffsetDateTime createdAt;
        private boolean isManaged;
        private List<DeviceWarningsItem> warnings = new ArrayList<DeviceWarningsItem>();
        private List<DeviceErrorsItem> errors = new ArrayList<DeviceErrorsItem>();
        private Optional<Object> location = Optional.empty();
        private List<DeviceCapabilitiesSupportedItem> capabilitiesSupported = new ArrayList<DeviceCapabilitiesSupportedItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Device other) {
            this.deviceId(other.getDeviceId());
            this.deviceType(other.getDeviceType());
            this.capabilitiesSupported(other.getCapabilitiesSupported());
            this.properties(other.getProperties());
            this.location(other.getLocation());
            this.connectedAccountId(other.getConnectedAccountId());
            this.workspaceId(other.getWorkspaceId());
            this.errors(other.getErrors());
            this.warnings(other.getWarnings());
            this.createdAt(other.getCreatedAt());
            this.isManaged(other.getIsManaged());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public DeviceTypeStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="device_type")
        public PropertiesStage deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        @JsonSetter(value="properties")
        public ConnectedAccountIdStage properties(DeviceProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        @JsonSetter(value="connected_account_id")
        public WorkspaceIdStage connectedAccountId(String connectedAccountId) {
            this.connectedAccountId = connectedAccountId;
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public CreatedAtStage workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IsManagedStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="is_managed")
        public _FinalStage isManaged(boolean isManaged) {
            this.isManaged = isManaged;
            return this;
        }

        @Override
        public _FinalStage addAllWarnings(List<DeviceWarningsItem> warnings) {
            this.warnings.addAll(warnings);
            return this;
        }

        @Override
        public _FinalStage addWarnings(DeviceWarningsItem warnings) {
            this.warnings.add(warnings);
            return this;
        }

        @Override
        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public _FinalStage warnings(List<DeviceWarningsItem> warnings) {
            this.warnings.clear();
            this.warnings.addAll(warnings);
            return this;
        }

        @Override
        public _FinalStage addAllErrors(List<DeviceErrorsItem> errors) {
            this.errors.addAll(errors);
            return this;
        }

        @Override
        public _FinalStage addErrors(DeviceErrorsItem errors) {
            this.errors.add(errors);
            return this;
        }

        @Override
        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public _FinalStage errors(List<DeviceErrorsItem> errors) {
            this.errors.clear();
            this.errors.addAll(errors);
            return this;
        }

        @Override
        public _FinalStage location(Object location) {
            this.location = Optional.of(location);
            return this;
        }

        @Override
        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public _FinalStage location(Optional<Object> location) {
            this.location = location;
            return this;
        }

        @Override
        public _FinalStage addAllCapabilitiesSupported(List<DeviceCapabilitiesSupportedItem> capabilitiesSupported) {
            this.capabilitiesSupported.addAll(capabilitiesSupported);
            return this;
        }

        @Override
        public _FinalStage addCapabilitiesSupported(DeviceCapabilitiesSupportedItem capabilitiesSupported) {
            this.capabilitiesSupported.add(capabilitiesSupported);
            return this;
        }

        @Override
        @JsonSetter(value="capabilities_supported", nulls=Nulls.SKIP)
        public _FinalStage capabilitiesSupported(List<DeviceCapabilitiesSupportedItem> capabilitiesSupported) {
            this.capabilitiesSupported.clear();
            this.capabilitiesSupported.addAll(capabilitiesSupported);
            return this;
        }

        @Override
        public Device build() {
            return new Device(this.deviceId, this.deviceType, this.capabilitiesSupported, this.properties, this.location, this.connectedAccountId, this.workspaceId, this.errors, this.warnings, this.createdAt, this.isManaged, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Device build();

        public _FinalStage capabilitiesSupported(List<DeviceCapabilitiesSupportedItem> var1);

        public _FinalStage addCapabilitiesSupported(DeviceCapabilitiesSupportedItem var1);

        public _FinalStage addAllCapabilitiesSupported(List<DeviceCapabilitiesSupportedItem> var1);

        public _FinalStage location(Optional<Object> var1);

        public _FinalStage location(Object var1);

        public _FinalStage errors(List<DeviceErrorsItem> var1);

        public _FinalStage addErrors(DeviceErrorsItem var1);

        public _FinalStage addAllErrors(List<DeviceErrorsItem> var1);

        public _FinalStage warnings(List<DeviceWarningsItem> var1);

        public _FinalStage addWarnings(DeviceWarningsItem var1);

        public _FinalStage addAllWarnings(List<DeviceWarningsItem> var1);
    }

    public static interface IsManagedStage {
        public _FinalStage isManaged(boolean var1);
    }

    public static interface CreatedAtStage {
        public IsManagedStage createdAt(OffsetDateTime var1);
    }

    public static interface WorkspaceIdStage {
        public CreatedAtStage workspaceId(String var1);
    }

    public static interface ConnectedAccountIdStage {
        public WorkspaceIdStage connectedAccountId(String var1);
    }

    public static interface PropertiesStage {
        public ConnectedAccountIdStage properties(DeviceProperties var1);
    }

    public static interface DeviceTypeStage {
        public PropertiesStage deviceType(DeviceType var1);
    }

    public static interface DeviceIdStage {
        public DeviceTypeStage deviceId(String var1);

        public Builder from(Device var1);
    }
}

