package com.obermuhlner.scriptengine.java.constructor;

import com.obermuhlner.scriptengine.java.JavaCompiledScript;

import javax.script.ScriptException;

/**
 * A {@link ConstructorStrategy} implementation that always returns {@code null}.
 *
 * Used to indicate that only static methods should be called to evaluate the
 * {@link JavaCompiledScript} holding the {@link Class}.
 */
public class NullConstructorStrategy implements ConstructorStrategy {
    @Override
    public Object construct(Class<?> clazz) throws ScriptException {
        return null;
    }
}
