/*
 * Decompiled with CFR 0.152.
 */
package com.obermuhlner.scriptengine.java;

import com.obermuhlner.scriptengine.java.JavaScriptEngine;
import com.obermuhlner.scriptengine.java.bindings.BindingStrategy;
import com.obermuhlner.scriptengine.java.execution.ExecutionStrategy;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class JavaCompiledScript
extends CompiledScript {
    private final JavaScriptEngine engine;
    private final Class<?> compiledClass;
    private final Object compiledInstance;
    private ExecutionStrategy executionStrategy;
    private BindingStrategy bindingStrategy;

    JavaCompiledScript(JavaScriptEngine engine, Class<?> compiledClass, Object compiledInstance, ExecutionStrategy executionStrategy, BindingStrategy bindingStrategy) {
        this.engine = engine;
        this.compiledClass = compiledClass;
        this.compiledInstance = compiledInstance;
        this.executionStrategy = executionStrategy;
        this.bindingStrategy = bindingStrategy;
    }

    public Class<?> getCompiledClass() {
        return this.compiledClass;
    }

    public Object getCompiledInstance() {
        return this.compiledInstance;
    }

    @Deprecated
    public Class<?> getInstanceClass() {
        return this.getCompiledClass();
    }

    @Deprecated
    public Object getInstance() {
        return this.getCompiledInstance();
    }

    public void setExecutionStrategy(ExecutionStrategy executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    @Override
    public Object eval(ScriptContext context) throws ScriptException {
        Bindings globalBindings = context.getBindings(200);
        Bindings engineBindings = context.getBindings(100);
        this.pushVariables(globalBindings, engineBindings);
        Object result = this.executionStrategy.execute(this.compiledInstance);
        this.pullVariables(globalBindings, engineBindings);
        return result;
    }

    private void pushVariables(Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        Map<String, Object> mergedBindings = this.mergeBindings(globalBindings, engineBindings);
        if (this.bindingStrategy != null) {
            this.bindingStrategy.associateBindings(this.compiledClass, this.compiledInstance, mergedBindings);
            return;
        }
        for (Map.Entry<String, Object> entry : mergedBindings.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                Field field = this.compiledClass.getField(name);
                field.set(this.compiledInstance, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ScriptException(e);
            }
        }
    }

    private void pullVariables(Bindings globalBindings, Bindings engineBindings) throws ScriptException {
        if (this.bindingStrategy != null) {
            Map<String, Object> retrievedBindings = this.bindingStrategy.retrieveBindings(this.compiledClass, this.compiledInstance);
            for (Map.Entry<String, Object> entry : retrievedBindings.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                this.setBindingsValue(globalBindings, engineBindings, name, value);
            }
            return;
        }
        for (Field field : this.compiledClass.getFields()) {
            try {
                String name = field.getName();
                Object value = field.get(this.compiledInstance);
                this.setBindingsValue(globalBindings, engineBindings, name, value);
            }
            catch (IllegalAccessException e) {
                throw new ScriptException(e);
            }
        }
    }

    private void setBindingsValue(Bindings globalBindings, Bindings engineBindings, String name, Object value) {
        if (!engineBindings.containsKey(name) && globalBindings.containsKey(name)) {
            globalBindings.put(name, value);
        } else {
            engineBindings.put(name, value);
        }
    }

    private Map<String, Object> mergeBindings(Bindings ... bindingsToMerge) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (Bindings bindings : bindingsToMerge) {
            if (bindings == null) continue;
            for (Map.Entry globalEntry : bindings.entrySet()) {
                variables.put((String)globalEntry.getKey(), globalEntry.getValue());
            }
        }
        return variables;
    }
}

