/*
 * Decompiled with CFR 0.152.
 */
package com.obermuhlner.scriptengine.java.compilation;

import com.obermuhlner.scriptengine.java.MemoryFileManager;
import com.obermuhlner.scriptengine.java.compilation.CompilationStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.tools.JavaFileObject;

public class IncrementalCompilationStrategy
implements CompilationStrategy {
    Map<String, JavaFileObject> previousFileObject = new HashMap<String, JavaFileObject>();
    JavaFileObject currentJavaFileObject;

    @Override
    public List<JavaFileObject> getJavaFileObjectsToCompile(String simpleClassName, String currentSource) {
        this.currentJavaFileObject = MemoryFileManager.createSourceFileObject(null, simpleClassName, currentSource);
        Stream<JavaFileObject> previousFileObjects = this.previousFileObject.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(simpleClassName)).map(Map.Entry::getValue);
        return Stream.concat(previousFileObjects, Stream.of(this.currentJavaFileObject)).toList();
    }

    @Override
    public void compilationResult(Class<?> clazz) {
        this.previousFileObject.put(clazz.getSimpleName(), this.currentJavaFileObject);
    }
}

