/*
 * Decompiled with CFR 0.152.
 */
package com.obermuhlner.scriptengine.java.execution;

import com.obermuhlner.scriptengine.java.execution.ExecutionStrategy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.script.ScriptException;

public class DefaultExecutionStrategy
implements ExecutionStrategy {
    private final Class<?> clazz;
    private final Method method;

    public DefaultExecutionStrategy(Class<?> clazz) {
        this.method = DefaultExecutionStrategy.findCallableMethod(clazz);
        this.clazz = clazz;
    }

    @Override
    public Object execute(Object instance) throws ScriptException {
        if (instance instanceof Supplier) {
            Supplier supplier = (Supplier)instance;
            return supplier.get();
        }
        if (instance instanceof Runnable) {
            Runnable runnable = (Runnable)instance;
            runnable.run();
            return null;
        }
        if (this.method != null) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ScriptException(e);
            }
        }
        if (instance == null) {
            throw new ScriptException("No static method found to execute of type " + this.clazz.getName());
        }
        throw new ScriptException("No method found to execute instance of type " + this.clazz.getName());
    }

    private static Method findCallableMethod(Class<?> clazz) {
        ArrayList<Method> callableMethods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (method.getParameterCount() != 0 || !Modifier.isPublic(modifiers)) continue;
            callableMethods.add(method);
        }
        if (callableMethods.size() == 1) {
            return (Method)callableMethods.get(0);
        }
        return null;
    }
}

