/*
 * Decompiled with CFR 0.152.
 */
package com.obermuhlner.scriptengine.java.execution;

import com.obermuhlner.scriptengine.java.execution.ExecutionStrategy;
import com.obermuhlner.scriptengine.java.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.script.ScriptException;

public class MethodExecutionStrategy
implements ExecutionStrategy {
    private Method method;
    private Object[] arguments;

    private MethodExecutionStrategy(Method method, Object ... arguments) {
        this.method = method;
        this.arguments = arguments;
    }

    @Override
    public Object execute(Object instance) throws ScriptException {
        try {
            return this.method.invoke(instance, this.arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ScriptException(e);
        }
    }

    public static MethodExecutionStrategy byMethod(Method method, Object ... arguments) {
        return new MethodExecutionStrategy(method, arguments);
    }

    public static MethodExecutionStrategy byMainMethod(Class<?> clazz, String ... arguments) throws ScriptException {
        try {
            Method method = clazz.getMethod("main", String[].class);
            return new MethodExecutionStrategy(method, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptException(e);
        }
    }

    public static MethodExecutionStrategy byArgumentTypes(Class<?> clazz, String methodName, Class<?>[] argumentTypes, Object ... arguments) throws ScriptException {
        try {
            Method method = clazz.getMethod(methodName, argumentTypes);
            return MethodExecutionStrategy.byMethod(method, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptException(e);
        }
    }

    public static MethodExecutionStrategy byMatchingArguments(Class<?> clazz, String methodName, Object ... arguments) throws ScriptException {
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || (method.getModifiers() & 1) == 0 || !ReflectionUtil.matchesArguments(method, arguments)) continue;
            matchingMethods.add(method);
        }
        int count = matchingMethods.size();
        if (count == 0) {
            throw new ScriptException("No method '" + methodName + "' with matching arguments found");
        }
        if (count > 1) {
            throw new ScriptException("Ambiguous methods '" + methodName + "' with matching arguments found: \n" + matchingMethods.stream().map(Object::toString).collect(Collectors.joining("\n")));
        }
        return MethodExecutionStrategy.byMethod((Method)matchingMethods.get(0), arguments);
    }
}

