/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.base.scanner;

import io.github.simonalexs.base.scanner.FileScanner;
import io.github.simonalexs.base.scanner.IScan;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarScanner
implements IScan {
    @Override
    public List<Class<?>> search(String packageName, Predicate<Class<?>> predicate) {
        HashSet classes = new HashSet();
        try {
            Enumeration<URL> urlEnumeration = Thread.currentThread().getContextClassLoader().getResources(packageName.replace(".", "/"));
            while (urlEnumeration.hasMoreElements()) {
                URL url = urlEnumeration.nextElement();
                String protocol = url.getProtocol();
                if ("jar".equalsIgnoreCase(protocol)) {
                    JarFile jarFile;
                    JarURLConnection connection = (JarURLConnection)url.openConnection();
                    if (connection == null || (jarFile = connection.getJarFile()) == null) continue;
                    Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                    while (jarEntryEnumeration.hasMoreElements()) {
                        JarEntry entry = jarEntryEnumeration.nextElement();
                        String jarEntryName = entry.getName();
                        if (!jarEntryName.contains(".class") || !jarEntryName.replaceAll("/", ".").startsWith(packageName)) continue;
                        String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replace("/", ".");
                        Class<?> cls = Class.forName(className);
                        if (predicate != null && !predicate.test(cls)) continue;
                        classes.add(cls);
                    }
                    continue;
                }
                if (!"file".equalsIgnoreCase(protocol)) continue;
                FileScanner fileScanner = new FileScanner();
                fileScanner.defaultClassPath = url.getPath().replace(packageName.replace(".", "/"), "");
                classes.addAll(fileScanner.search(packageName, predicate));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return new ArrayList(classes);
    }
}

