/*
 * Decompiled with CFR 0.152.
 */
package io.github.simonalexs.handler;

import io.github.simonalexs.Starter;
import io.github.simonalexs.annotation.Func;
import io.github.simonalexs.annotation.Param;
import io.github.simonalexs.tools.ClassScannerUtil;
import io.github.simonalexs.tools.StringUtil;
import io.github.simonalexs.tools.other.PrintUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UtilHandler {
    public static final Map<String, List<FuncInfo>> MODULE_2_FUNCS_MAP = new LinkedHashMap<String, List<FuncInfo>>();

    public static Map<String, List<FuncInfo>> getModule2FuncsMap() {
        LinkedHashMap<String, List<FuncInfo>> copy = new LinkedHashMap<String, List<FuncInfo>>();
        MODULE_2_FUNCS_MAP.forEach((model, funcs) -> {
            ArrayList<FuncInfo> funcInfoListCopy = new ArrayList<FuncInfo>();
            for (FuncInfo func : funcs) {
                funcInfoListCopy.add(func.clone());
            }
            copy.put((String)model, (List<FuncInfo>)funcInfoListCopy);
        });
        return copy;
    }

    static {
        String basePackageName = Starter.class.getPackage().getName();
        List<Class<?>> classList = ClassScannerUtil.searchClasses(basePackageName);
        LinkedHashMap map = new LinkedHashMap();
        for (Class<?> aClass : classList) {
            for (Method method : aClass.getDeclaredMethods()) {
                if (method.getAnnotation(Func.class) == null) continue;
                FuncInfo funcInfo = new FuncInfo(method);
                String module = funcInfo.module();
                if (!map.containsKey(module)) {
                    map.put(module, new ArrayList());
                }
                ((List)map.get(module)).add(funcInfo);
            }
        }
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            List sortedFuncInfos = ((List)e.getValue()).stream().sorted(Comparator.comparing(FuncInfo::name)).collect(Collectors.toList());
            MODULE_2_FUNCS_MAP.put((String)e.getKey(), sortedFuncInfos);
        });
    }

    public static class FuncInfo {
        public Method func;
        public String desc;
        public List<ParamInfo> params;

        public FuncInfo(Method method) {
            this.func = method;
            Func methodAnnotation = method.getAnnotation(Func.class);
            this.desc = methodAnnotation.value().isEmpty() ? StringUtil.humpToSpace(this.name()) : methodAnnotation.value();
            this.params = new ArrayList<ParamInfo>();
            for (Parameter parameter : method.getParameters()) {
                Param parameterAnnotation = parameter.getAnnotation(Param.class);
                ParamInfo paramInfo = new ParamInfo();
                paramInfo.name = parameter.getName();
                paramInfo.tip = parameterAnnotation == null || parameterAnnotation.tip().isEmpty() ? StringUtil.humpToSpace(parameter.getName()) : parameterAnnotation.tip();
                paramInfo.currentValue = parameterAnnotation == null ? "" : parameterAnnotation.value();
                paramInfo.parser = StringUtil.getParser(parameter.getType());
                this.params.add(paramInfo);
            }
        }

        public FuncInfo clone() {
            return new FuncInfo(this.func);
        }

        public String name() {
            return this.func.getName();
        }

        public String module() {
            String className = this.func.getDeclaringClass().getSimpleName();
            String classPrefix = className.replaceAll("(?i)util$", "");
            return StringUtil.toLowerCaseFirst(classPrefix);
        }

        public void show() {
            System.out.println();
            System.out.println("func info:");
            List<List> funcContent = Arrays.asList(Arrays.asList("module", "name", "desc"), Arrays.asList(this.module(), this.name(), this.desc));
            PrintUtil.println(funcContent);
            System.out.println("param info:");
            List<String> titles = Arrays.asList("order", "paramName", "currentValue", "desc");
            ArrayList<List<Object>> paramContent = new ArrayList<List<Object>>();
            for (int i = 0; i < this.params.size(); ++i) {
                ParamInfo paramInfo = this.params.get(i);
                List<Object> paramDescription = Arrays.asList(i + 1, paramInfo.name, paramInfo.currentValue, paramInfo.tip);
                paramContent.add(paramDescription);
            }
            PrintUtil.println("=", "-", "=", titles, paramContent);
            this.printCurrentCommand();
            System.out.println();
        }

        private void printCurrentCommand() {
            StringBuilder command = new StringBuilder();
            command.append(this.module()).append(" ").append(this.name());
            for (ParamInfo param : this.params) {
                command.append(" ").append(param.currentValue);
            }
            System.out.println("*************** current command is: " + command + " ******************");
        }

        public String run() {
            try {
                Object[] paramValues = new Object[this.params.size()];
                for (int i = 0; i < this.params.size(); ++i) {
                    Object value;
                    ParamInfo param = this.params.get(i);
                    paramValues[i] = value = param.parser.apply(param.currentValue);
                }
                Object invokedResult = this.func.invoke(null, paramValues);
                System.out.print("running success, ");
                Class<?> returnType = this.func.getReturnType();
                if (returnType == Void.class) {
                    System.out.println("no result.");
                } else {
                    System.out.println("result: " + invokedResult);
                }
                return "";
            }
            catch (Exception e) {
                return e.getClass().getName() + ": " + e.getMessage();
            }
        }
    }

    public static class ParamInfo {
        public String name;
        public String tip;
        public Function<String, Object> parser;
        public String currentValue;
    }
}

